
/******************************************************************************
*@file  : spl_wdt.h
*@brief : Header file of WDT SPL module.
******************************************************************************/

#ifndef __SPL_WDT_H__
#define __SPL_WDT_H__

#include "acm32g103_spl_conf.h"


/** @defgroup WDT_Cmd
  * @{
  */

#define WDT_CMD_FEED_WATCHDOG                 ( 0xAA55A55AU )

/**
  * @}
  */
/** @defgroup WDT_Clock_Prescaler
  * @{
  */

#define WDT_CLOCK_PRESCALER_1          ( 0U )
#define WDT_CLOCK_PRESCALER_2          ( WDT_CTRL_DIVISOR_0 )
#define WDT_CLOCK_PRESCALER_4          ( WDT_CTRL_DIVISOR_1 )
#define WDT_CLOCK_PRESCALER_8          ( WDT_CTRL_DIVISOR_1 | WDT_CTRL_DIVISOR_0 )
#define WDT_CLOCK_PRESCALER_16         ( WDT_CTRL_DIVISOR_2 )
#define WDT_CLOCK_PRESCALER_32         ( WDT_CTRL_DIVISOR_2 | WDT_CTRL_DIVISOR_0 )
#define WDT_CLOCK_PRESCALER_64         ( WDT_CTRL_DIVISOR_2 | WDT_CTRL_DIVISOR_1 )
#define WDT_CLOCK_PRESCALER_128        ( WDT_CTRL_DIVISOR_2 | WDT_CTRL_DIVISOR_1 | WDT_CTRL_DIVISOR_0 )

/**
  * @}
  */
  
/** @defgroup WDT_Mode
  * @{
  */

#define  WDT_MODE_RESET                 ( 0U )
#define  WDT_MODE_INTERRUPT             ( WDT_CTRL_MODE )

/**
  * @}
  */
  
/** @defgroup WDT_Flag
  * @{
  */

#define  WDT_FLAG_RIS                   ( WDT_RIS_WDTRIS )

/**
  * @}
  */
  

/**
  * @brief   
  */
  
#define  WDT_GET_IT_ENABLE(__HWDT__)        ( WDT->CTRL |= WDT_CTRL_INTEN )
  
#define  WDT_GET_IT_DISABLE(__HWDT__)       ( WDT->CTRL &= ~WDT_CTRL_INTEN )
  
#define  WDT_GET_RIS_FLAG(__HWDT__)         ( (WDT->RIS & WDT_RIS_WDTRIS) ? SET : RESET )
  
  
  
/** @defgroup  EXTI Private Macros
  * @{
  */
  
#define IS_WDT_FUNCTIONAL_STATE(_STATE_)    (((_STATE_) == ENABLE)      || \
                                             ((_STATE_) == DISABLE))
                                                 
#define IS_WDT_PRESCALER(__PRESCALER__)     (((__PRESCALER__) == WDT_CLOCK_PRESCALER_1)     || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_2)     || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_4)     || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_8)     || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_16)    || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_32)    || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_64)    || \
                                             ((__PRESCALER__) == WDT_CLOCK_PRESCALER_128))

#define IS_WDT_MODE(__MODE__)               (((__MODE__) == WDT_MODE_RESET)         || \
                                             ((__MODE__) == WDT_MODE_INTERRUPT))

#define IS_WDT_INTCLRTIME(__TIME__)          ((__TIME__) <= 0xFFFFU)

#define IS_WDT_FLAGS(__FLAG__)               ((__FLAG__) == WDT_FLAG_RIS)

/**
  * @}
  */
  
/* Exported functions --------------------------------------------------------*/


void WDT_DeInit(void);
void WDT_Cmd(FunctionalState NewState);
void WDT_SetPrescaler(uint32_t Prescaler);
void WDT_SetMode(uint32_t Mode);
void WDT_ITCmd(FunctionalState NewState);
void WDT_SetLoadValue(uint32_t Load);
uint32_t WDT_GetCounterValue(void);
void WDT_SetITClrTime(uint32_t ITClrTime);
void WDT_FeedDog(void);
FlagStatus WDT_GetFlagStatus(uint32_t Flag);



#endif
