
#include "acm32g103_spl_conf.h"


static __IO uint32_t g_SysTick = 0;


/******************************************************************************
*@brief : This function is called to increment  a global variable "g_msTick"
*           In the default implementation, this variable is incremented each 1ms in SysTick ISR.
*           This function is declared as __weak to be overwritten in case of other implementations in user file.
*@param : none
*@return: none
******************************************************************************/
__weak void SysTick_Inc(void)
{
	g_SysTick++;
}

/******************************************************************************
*@brief : Provides a tick value in millisecond
*         This function is declared as __weak to be overwritten in case of other implementations in user file.
*@return: none
******************************************************************************/
__weak uint32_t SysTick_Get(void)
{
    return (g_SysTick);
}

/******************************************************************************
*@brief : This function provides minimum delay (in milliseconds) based on variable incremented
*           This function is declared as __weak to be overwritten in case of other implementations in user file.
*@param : Delay: specifies the delay time length, in milliseconds.
*@return: none
******************************************************************************/
__weak void DelayMs(uint32_t Delay)
{
    uint32_t tick_start = SysTick_Get();

    while((SysTick_Get() - tick_start) < Delay)
    {
    }
}

/******************************************************************************
*@brief : Suspend Tick increment
*@param : none
*@return: none
******************************************************************************/
__weak void SysTick_Suspend(void)  
{
    SysTick->CTRL &= ~SysTick_CTRL_TICKINT_Msk;  
    SCB->ICSR = BIT25;
}

/******************************************************************************
*@brief : Resume Tick increment
*@param : none
*@return: none
******************************************************************************/
__weak void SysTick_Resume(void)  
{
    SysTick->CTRL |= SysTick_CTRL_TICKINT_Msk;   
}

/******************************************************************************
*@brief : ͨwhileѭʱ
*@param : delay: whileѭ
*@ret   : 
******************************************************************************/
void Delay_Simple(volatile uint32_t delay)
{
    while(delay--)
    {
        ;
    }
}

/******************************************************************************
*@brief : ֹжϣؽֹжǰ״̬
*@param : delay: whileѭ
*@ret   : 
******************************************************************************/
uint32_t EnterCritical(void)
{
    uint32_t save_irq;
    
    save_irq = __get_PRIMASK();
    __set_PRIMASK(1);
    return (save_irq);
}

/******************************************************************************
*@brief : ָжϣصж֮ǰж״̬
*@param : save_irq: ж״̬
*@ret   : 
******************************************************************************/
void ExitCritical(uint32_t save_irq)
{
    __set_PRIMASK(save_irq);
}



