
/******************************************************************************
*@file  : hal_systimer.c
*@brief : ϵͳʱģ顣ĬʹSysTickʱ¼
*         ûѡĶʱҪдº
*           void HAL_SYSTIMER_Init(void);
*           void HAL_SYSTIMER_SuppendTick(void);
*           void HAL_SYSTIMER_ResumeTick(void);
*           void HAL_SYSTIMER_Enable(void);
*           void HAL_SYSTIMER_Disable(void);
*           uint32_t HAL_SYSTIMER_GetMstick(void);
*           uint32_t HAL_SYSTIMER_GetClktick(void);
*           void HAL_SYSTIMER_GetClktickMstick(uint32_t *pClktick, uint32_t *pMstick);
******************************************************************************/

#include "hal.h"


SYSTIMER_HandleTypeDef g_systimerHandle;

/******************************************************************************
*@brief : systimerʼ
*@param : 
*@ret   : 
******************************************************************************/
__weak void HAL_SYSTIMER_Init(void)
{
    if(SysTick->CTRL & SysTick_CTRL_CLKSOURCE_Msk)
    {
        g_systimerHandle.freq = g_SystemCoreClock;
    }
    else
    {
         g_systimerHandle.freq = g_SystemCoreClock>>3;   //8Ƶ     
    }
    g_systimerHandle.period = SysTick->LOAD; 
    g_systimerHandle.direct = 1;  
    g_systimerHandle.clkPerUs = g_systimerHandle.freq / 1000000;
    g_systimerHandle.clkPerMs = g_systimerHandle.freq / 1000;    
    g_systimerHandle.msPeriod = g_TickFreq; 
    g_systimerHandle.usPer65536Clk = 65536 / g_systimerHandle.clkPerUs;
}

/******************************************************************************
*@brief : ϵͳʱжϡ
*@param : 
*@ret   : 
******************************************************************************/
__weak void HAL_SYSTIMER_SuppendTick(void)
{
    SysTick->CTRL  &=  ~(SysTick_CTRL_TICKINT_Msk);
}

/******************************************************************************
*@brief : ָϵͳʱжϡ
*@param : 
*@ret   : 
******************************************************************************/
__weak void HAL_SYSTIMER_ResumeTick(void)
{
    SysTick->CTRL  |=  SysTick_CTRL_TICKINT_Msk;
}


/******************************************************************************
*@brief : ʹܶʱ
*@param : 
*@ret   : 
******************************************************************************/
__weak void HAL_SYSTIMER_Enable(void)
{
    SysTick->CTRL  |=  SysTick_CTRL_ENABLE_Msk;
}

/******************************************************************************
*@brief : ֹͣʱ
*@param : 
*@ret   : 
******************************************************************************/
__weak void HAL_SYSTIMER_Disable(void)
{
    SysTick->CTRL  &=  ~(SysTick_CTRL_ENABLE_Msk);
}

/******************************************************************************
*@brief : ȡtick
*@param : 
*@ret   : 
******************************************************************************/
__weak uint32_t HAL_SYSTIMER_GetMstick(void)
{
   return g_Tick; 
}

/******************************************************************************
*@brief : ȡʱclktick
*@param : 
*@ret   : 
******************************************************************************/
__weak uint32_t HAL_SYSTIMER_GetClktick(void)
{
   return SysTick->VAL; 
}

/******************************************************************************
*@brief : ȡʱclktickmstick
*@param : 
*@ret   : 
******************************************************************************/
__weak void HAL_SYSTIMER_GetClktickMstick(uint32_t *pClktick, uint32_t *pMstick)
{
    do 
    {
        *pMstick = g_Tick;
        *pClktick= SysTick->VAL;
    } 
    while(g_Tick != *pMstick); 
}


/******************************************************************************
*@brief : ϵͳʱclkӳʱ䡣ֻܼ1ʱڡʱжϹرղӰ
*@param : clktickStart: ʼֵ
*@ret   : ӳʱ䣬λʱclk
******************************************************************************/
uint32_t HAL_SYSTIMER_GetClkDelay(uint32_t clktickStart)
{
    uint32_t clktickNow;

    clktickNow = HAL_SYSTIMER_GetClktick();
    
    if(g_systimerHandle.direct==0)  //ϼ
    {
        if(clktickNow >= clktickStart)
        {
            return (clktickNow - clktickStart);
        }
        else
        {
            return (g_systimerHandle.period + clktickNow - clktickStart);
        }            
    }
    else  //¼
    {
        if(clktickNow <= clktickStart)
        {
            return (clktickStart - clktickNow);
        }
        else
        {
            return (clktickStart + g_systimerHandle.period - clktickNow);
        }         
    }
}

/******************************************************************************
*@brief : delay񡣻ȡǰtickʼdelay handle
*@param : hdelay: delay handle
*@ret   : 
******************************************************************************/
void HAL_SYSTIMER_StartDelay(SYSTIMER_DelayHandleTypeDef *hdelay)
{
    do 
    {
        hdelay->mstickLatest = HAL_SYSTIMER_GetMstick();
        hdelay->clktickLatest = HAL_SYSTIMER_GetClktick();
    } 
    while(HAL_SYSTIMER_GetMstick() != hdelay->mstickLatest);
    
    hdelay->clkCount = 0;  
    hdelay->msCount = 0;  
}

/******************************************************************************
*@brief : delay
*@param : hdelay: delay handle
*@ret   : 
******************************************************************************/
void HAL_SYSTIMER_UpdateDelay(SYSTIMER_DelayHandleTypeDef *hdelay)
{
    uint32_t clktickNow, mstickNow;
    
    HAL_SYSTIMER_GetClktickMstick(&clktickNow, &mstickNow);
    
    if(mstickNow - hdelay->mstickLatest < g_systimerHandle.msPeriod)
    {
        if(g_systimerHandle.direct==0)  //ϼ
        {
            if(clktickNow >= hdelay->clktickLatest)
            {
                hdelay->clkCount += clktickNow - hdelay->clktickLatest;
            }
            else
            {
                hdelay->clkCount += g_systimerHandle.period + clktickNow - hdelay->clktickLatest;
            }            
        }
        else  //¼
        {
            if(clktickNow <= hdelay->clktickLatest)
            {
                hdelay->clkCount += hdelay->clktickLatest - clktickNow;
            }
            else
            {
                hdelay->clkCount += hdelay->clktickLatest + g_systimerHandle.period - clktickNow;
            }
        }
    }
    else
    {
        if(g_systimerHandle.direct==0)  //ϼ
        {
            hdelay->clkCount += g_systimerHandle.period + clktickNow - hdelay->clktickLatest;          
        }
        else  //¼
        {
            hdelay->clkCount += hdelay->clktickLatest + g_systimerHandle.period - clktickNow;
        }
        hdelay->msCount += (mstickNow - hdelay->mstickLatest) - g_systimerHandle.msPeriod;
    }
    hdelay->clktickLatest = clktickNow;   
    hdelay->mstickLatest = mstickNow;    
    
    if(hdelay->clkCount >= g_systimerHandle.period)
    {
        hdelay->clkCount -= g_systimerHandle.period;
        hdelay->msCount += g_systimerHandle.msPeriod;
    }
//    
//    while(hdelay->clkCount >= g_systimerHandle.clkPerMs)
//    {
//        hdelay->clkCount -= g_systimerHandle.clkPerMs;
//        hdelay->msCount++;
//    }    
    
}

/******************************************************************************
*@brief : delayʼǰʱ΢ӳ١ʱ70ҡʱжϹرպҲʹá
*         ʱжϹرգÿʱҪHAL_SYSTIMER_UpdateDelay߱2ϣ
*           ᵼ·صʱʱʵʱƫС
*         ʱжϿûơ
*@param : hdelay: delay handle
*@ret   : ΢ӳ
******************************************************************************/
uint32_t HAL_SYSTIMER_GetUsDelay(SYSTIMER_DelayHandleTypeDef *hdelay)
{
    uint32_t us;
    HAL_SYSTIMER_UpdateDelay(hdelay);
    
    us = (hdelay->clkCount * g_systimerHandle.usPer65536Clk) >> 16;
    us += hdelay->msCount * 1000;    
    return us;
}

/******************************************************************************
*@brief : delayʼǰʱĺӳ١ʱжϹرպҲʹá
*         ʱжϹرգÿʱҪHAL_SYSTIMER_UpdateDelay߱2ϣ
*           ᵼ·صʱʱʵʱƫС
*         ʱжϿûơ
*@param : hdelay: delay handle
*@ret   : ӳ
******************************************************************************/
uint32_t HAL_SYSTIMER_GetMsDelay(SYSTIMER_DelayHandleTypeDef *hdelay)
{
    HAL_SYSTIMER_UpdateDelay(hdelay);
    
    return hdelay->msCount; 
}

/******************************************************************************
*@brief : ʼmstickʼǰʱĺӳ١ʹñҪǰʱжϡ
*@param : msTickStart: ʼmstick
*@ret   : ӳ
******************************************************************************/
uint32_t HAL_SYSTIMER_GetMsDelay_NeedInt(uint32_t msTickStart)
{
    return (HAL_SYSTIMER_GetMstick() - msTickStart);
}

/******************************************************************************
*@brief : ϵͳʱʱʱʱжϹرҲɼʱ100MHzʱʱʱ32룬ʱԴơ
*@param : clks: ʱclks
*@ret   : 
******************************************************************************/
void HAL_SYSTIMER_DelayClks(uint32_t clks)
{
    uint32_t clktickStart, clktickNow;
    uint32_t count;

    clktickStart = HAL_SYSTIMER_GetClktick();
    count = 0;
    while(1)
    {
        clktickNow = HAL_SYSTIMER_GetClktick();
        
        if(g_systimerHandle.direct==0)  //ϼ
        {
            if(clktickNow >= clktickStart)
            {
                count += clktickNow - clktickStart;
            }
            else
            {
                count += g_systimerHandle.period + clktickNow - clktickStart;
            }
        }
        else  //¼
        {
            if(clktickNow <= clktickStart)
            {
                count += clktickStart - clktickNow;
            }
            else
            {
                count += clktickStart + g_systimerHandle.period - clktickNow;
            }
        }
        
        if(count >= clks)
        {
            return;
        }
        clktickStart = clktickNow;
    }
}

/******************************************************************************
*@brief : ΢ʱʱжϹرҲɼʱʱ70ҡ
*@param : us: ʱ΢
*@ret   : 
******************************************************************************/
void HAL_SYSTIMER_DelayUs(uint32_t us)
{
    if(us<1000000)
    {
        HAL_SYSTIMER_DelayClks(g_systimerHandle.clkPerUs * us);
    }
    else
    {
        HAL_SYSTIMER_DelayMs(us/1000);
    }
}

/******************************************************************************
*@brief : ʱʱжϹرҲɼʱʱ49ҡ
*@param : ms: ʱĺ
*@ret   : 
******************************************************************************/
void HAL_SYSTIMER_DelayMs(uint32_t ms)
{
    while(ms--)
    {
        HAL_SYSTIMER_DelayClks(g_systimerHandle.clkPerMs);
    }
}

/******************************************************************************
*@brief : ΢ʱʱжϹرҲɼʱʱ70ҡ
*@param : us: ʱ΢
*@ret   : 
******************************************************************************/
__weak void delay_us(uint32_t us)
{
    HAL_SYSTIMER_DelayClks(g_systimerHandle.clkPerUs * us);
}

/******************************************************************************
*@brief : ʱʱжϹرҲɼʱʱ49ҡ
*@param : ms: ʱĺ
*@ret   : 
******************************************************************************/
__weak void delay_ms(uint32_t ms)
{
    while(ms--)
    {
        HAL_SYSTIMER_DelayClks(g_systimerHandle.clkPerMs);
    }
}


/*****************************************************************
@	ʱ
@	count[in]:ʱʱ
@	
******************************************************************/

/******************************************************************************
*@brief : ʱwhile(1)ѭ
*@param : count: ѭ
*@ret   : 
******************************************************************************/
__weak void delay(uint32_t count)
{
    while(count--);
}

