
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

#define ADC_NUM    (2)
uint32_t gadcBuffer[ADC_NUM] = {0};
uint32_t gadcCommonData = 0;                 

#define DUAL_MADCX    (ADC1)
#define DUAL_SADCX    (ADC2)


/******************************************************************************
* @brief : ADC GPIO config.
* @param : None
* @return: None
******************************************************************************/
void ADC_GPIO_Config(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
    
    __RCC_GPIOC_CLK_ENABLE();
    
    /* Configure ADC Channel_10 pin as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);

    /* Configure ADC Channel_15 pin as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_5;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);    
}

/******************************************************************************
* @brief : ADC Common register config.
* @param : None
* @return: None
******************************************************************************/
void ADC_Common_Register_Config(void)
{
    ADC_CommonInitTypeDef ADC_CommonInitStructure;

    ADC_CommonInitStructure.ADC_Mode = ADC_DUALMODE_INJECSIMULT;//˫ADCģʽѡ
    ADC_CommonInitStructure.ADC_Prescaler = ADC_CLOCK_DIV4;//ADC_CLKƵѡ
    ADC_CommonInitStructure.ADC_DMAAccessMode = ADC_DMAACCESSMODE_DISABLED;//˫ADCDMAѡ
    ADC_CommonInitStructure.ADC_TwoSamplingDelay = ADC_TWOSAMPLINGDELAY_5CYCLES;//2׶֮ӳ
    ADC_CommonInit(&ADC_CommonInitStructure);
}

/******************************************************************************
* @brief : Master ADC config.
* @param : None
* @return: None
******************************************************************************/
void Master_ADC_Config(void)
{
    ADC_InitTypeDef ADC_InitStructure;
    
    ADC_InitStructure.ADC_Resolution = ADC_RESOLUTION_12B;//ֱ
    ADC_InitStructure.ADC_ContinuousConvMode = ADC_CONT_DISABLE;//תģʽ
    ADC_InitStructure.ADC_ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;//ⲿѡ
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_EXTERNAL_TIG0;//ģʽ
    ADC_InitStructure.ADC_DataAlign = ADC_DATAALIGN_RIGHT;//ݶ
    ADC_InitStructure.ADC_NbrOfConversion = 1;//ͨг
    ADC_Init(DUAL_MADCX, &ADC_InitStructure);
    
    //ͨ
    ADC_InjectedChannelConfig(DUAL_MADCX, ADC_CHANNEL_10, ADC_INJECTED_RANK_1, ADC_SMP_CLOCK_320);   
}

/******************************************************************************
* @brief : Slave ADC config.
* @param : None
* @return: None
******************************************************************************/
void Slave_ADC_Config(void)
{
    ADC_InitTypeDef ADC_InitStructure;
    
    ADC_InitStructure.ADC_Resolution = ADC_RESOLUTION_12B;//ֱ
    ADC_InitStructure.ADC_ContinuousConvMode = ADC_CONT_DISABLE;//תģʽ
    ADC_InitStructure.ADC_ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;//ⲿѡ
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_EXTERNAL_TIG0;//ģʽ
    ADC_InitStructure.ADC_DataAlign = ADC_DATAALIGN_RIGHT;//ݶ
    ADC_InitStructure.ADC_NbrOfConversion = 1;//ͨг
    ADC_Init(DUAL_SADCX, &ADC_InitStructure);
    
    //ͨ
    ADC_InjectedChannelConfig(DUAL_SADCX, ADC_CHANNEL_15, ADC_INJECTED_RANK_1, ADC_SMP_CLOCK_320);
}

/******************************************************************************
* @brief:  Enable ADC, start conversion of injected channel.
* @param:  None.
* @return: None
******************************************************************************/
void Dual_ADC_InjectedStart(void)
{  
    //ADC
    ADC_Cmd(DUAL_MADCX, ENABLE);
    ADC_Cmd(DUAL_SADCX, ENABLE);

    //עͨת־
    ADC_ClearFlag(DUAL_MADCX, ADC_IT_FLAG_JEOC);
    ADC_ClearFlag(DUAL_SADCX, ADC_IT_FLAG_JEOC); 

    //ʼתADCעͨ
    ADC_SoftwareStartInjectedConv(DUAL_MADCX);	

}

/******************************************************************************
* @brief : ADC function test.
* @param : None
* @return: None
******************************************************************************/
void APP_ADC_Test(void)
{
    uint32_t i;
    
    printfS("ADC Dual test \r\n");
    
    
    ADC_GPIO_Config();
    
    //ADC1
    Master_ADC_Config();
    //ADC2
    Slave_ADC_Config();
    //עͬģʽ
    ADC_Common_Register_Config();
    
    while(1)
    {
      
        Dual_ADC_InjectedStart();

        while(!ADC_GetFlagStatus(DUAL_MADCX, ADC_SR_JEOC)){};
        ADC_ClearFlag(DUAL_MADCX, ADC_SR_JEOC);			
        gadcBuffer[0] = ADC_GetInjectedConversionValue(DUAL_MADCX, ADC_JDR_1);
        printfS("Master ADC1 Inject Rank1 convert result : Channel %d = %d\r\n", ((gadcBuffer[0] >> 16) & 0xFF), (gadcBuffer[0] & 0xfff));  
        gadcBuffer[0] = 0;

        
        while(!ADC_GetFlagStatus(DUAL_SADCX, ADC_SR_JEOC)){printfS("DUAL_SADCX->SR = 0x%08x\r\n", DUAL_SADCX->SR);};
        ADC_ClearFlag(DUAL_SADCX, ADC_SR_JEOC);			
        gadcBuffer[1] = ADC_GetInjectedConversionValue(DUAL_SADCX, ADC_JDR_1);
        printfS("Slave ADC2 Inject Rank1 convert result : Channel %d = %d\r\n", ((gadcBuffer[1] >> 16) & 0xFF), (gadcBuffer[1] & 0xfff)); 	
        gadcBuffer[1] = 0;
        
        DelayMs(1000);     
    }
    
    
    
}






