
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

#define ADC_NUM    (1)
uint32_t gadcBuffer[ADC_NUM]; 
static volatile uint32_t gadcInjectConFlag = 0;                

#define ADCX    (ADC2)

/******************************************************************************
* @brief:  ADC Interrupt callback.
* @param:  None.
* @return: None
******************************************************************************/
void ADC_IRQCallback(void)
{
    if(SET == ADC_GetITStatus(ADCX, ADC_IT_FLAG_JEOC))
    {
        gadcInjectConFlag = 1;
        gadcBuffer[0] = ADC_GetInjectedConversionValue(ADCX, ADC_JDR_1);
        ADC_ClearITPendingBit(ADCX, ADC_IT_FLAG_JEOC);
    }  
}

/******************************************************************************
* @brief : ADC GPIO config.
* @param : None
* @return: None
******************************************************************************/
void ADC_GPIO_Config(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
   
    __RCC_GPIOC_CLK_ENABLE();
    
    /* Configure ADC Channel_15 pin as analog input */
    GPIO_InitStruct.Pin       = GPIO_PIN_5;
    GPIO_InitStruct.Mode      = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
    GPIO_Init(GPIOC, &GPIO_InitStruct);    
}

/******************************************************************************
* @brief : ADC Common register config.
* @param : None
* @return: None
******************************************************************************/
void ADC_Common_Register_Config(void)
{
    ADC_CommonInitTypeDef ADC_CommonInitStructure;

    ADC_CommonInitStructure.ADC_Mode = ADC_MODE_INDEPENDENT;//˫ADCģʽѡ
    ADC_CommonInitStructure.ADC_Prescaler = ADC_CLOCK_DIV4;//ADC_CLKƵѡ
    ADC_CommonInitStructure.ADC_DMAAccessMode = ADC_DMAACCESSMODE_DISABLED;//˫ADCDMAѡ
    ADC_CommonInitStructure.ADC_TwoSamplingDelay = ADC_TWOSAMPLINGDELAY_5CYCLES;//2׶֮ӳ
    ADC_CommonInit(&ADC_CommonInitStructure);
}

/******************************************************************************
* @brief : ADC config.
* @param : None
* @return: None
******************************************************************************/
void ADC_Config(void)
{
    ADC_InitTypeDef ADC_InitStructure;
    
    ADC_InitStructure.ADC_Resolution = ADC_RESOLUTION_12B;//ֱ
    ADC_InitStructure.ADC_ContinuousConvMode = ADC_CONT_DISABLE;//תģʽ
    ADC_InitStructure.ADC_ExternalTrigConvEdge = ADC_EXTERNALTRIGCONVEDGE_NONE;//ⲿѡ
    ADC_InitStructure.ADC_ExternalTrigConv = ADC_EXTERNAL_TIG0;//ģʽ
    ADC_InitStructure.ADC_DataAlign = ADC_DATAALIGN_RIGHT;//ݶ
    ADC_InitStructure.ADC_NbrOfConversion = ADC_NUM;//ͨг
    ADC_Init(ADCX, &ADC_InitStructure);
    
    //עͨ
    ADC_InjectedSequencerLengthConfig(ADCX, 1);//עͨг
    ADC_InjectedChannelConfig(ADCX, ADC_CHANNEL_15, ADC_INJECTED_RANK_1, ADC_SMP_CLOCK_320);

}


/******************************************************************************
* @brief:  Enable ADC, start conversion of injected channel with interruption.
* @param:  None.
* @return: None
******************************************************************************/
void ADC_InjectedStart_IT(void)
{  
    //ADC
    ADC_Cmd(ADCX, ENABLE);

    //עͨת־
    ADC_ClearFlag(ADCX, ADC_IT_FLAG_JEOC);
    
    //ʹעͨתж
    ADC_ITConfig(ADCX, ADC_IT_FLAG_JEOC, ENABLE);   

    //ʼתעͨ
    ADC_SoftwareStartInjectedConv(ADCX);	

}

/******************************************************************************
* @brief : ADC function test.
* @param : None
* @return: None
******************************************************************************/
void APP_ADC_Test(void)
{
    uint32_t i;
    
    printfS("ADC Interrupt test \r\n");
    
    ADC_GPIO_Config();
    
    ADC_Common_Register_Config();
    
    ADC_Config();
    
    NVIC_ClearPendingIRQ(ADC12_IRQn);	
    NVIC_SetPriority(ADC12_IRQn, 5);
    NVIC_EnableIRQ(ADC12_IRQn);
    
    while(1)
    {
        if(gadcInjectConFlag)
        {
            gadcInjectConFlag = 0;   
            printfS("The adc convert result : Channel %d = %d\r\n", gadcBuffer[0]>>16 & 0xFF, gadcBuffer[0] & 0xFFF);        

        }
        else 
        {
            printfS("Wait for ADC Irq \r\n");
            ADC_InjectedStart_IT();
        }
        DelayMs(1000);     
    }
    
    
    
}






