/*
  ******************************************************************************
  * @file    main.c
  * @brief   main source File.
  ******************************************************************************
*/
#include "app.h"

/*********************************************************************************
* Function    : main
* Description : 
**********************************************************************************/
int main(void)
{
    RCC_ClocksTypeDef RCC_Clocks;
    
	#if (INS_ACCELERATE_ENABLE == 1)
		System_EnableIAccelerate();
	#endif

	#if (DATA_ACCELERATE_ENABLE == 1)
		System_EnableDAccelerate();
	#endif     
    
	/* Set Interrupt Group Priority */
	NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
    
    SystemClock_Config();    
    
    SystemCoreClockUpdate();
    
    RCC_GetClocksFreq(&RCC_Clocks);
    
    SysTick_Config(RCC_Clocks.HCLK_Frequency / 1000);
    
    BSP_UART_Init();  
    
    BSP_PB_Init();
	
	printfS("\r\n\r\n");
	printfS("************************************************************\r\n\r\n");
	printfS("system startup\r\n");
	    
	printfS("HCK: %u\r\n", RCC_GetHCLKFreq());
	printfS("PCLK1: %u\r\n", RCC_GetPCLK1Freq());
	printfS("PCLK2: %u\r\n", RCC_GetPCLK2Freq());
    printfS("\r\n");
	printfS("************************************************************\r\n\r\n");
	
	/* Select Mode: TEST_LOOP、TEST_UART_IT、TEST_DMA*/  
    APP_CAN_Test(TEST_IT); 
	
    while(1)
    {

    }
}

