
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

#define TIM_CLOCK_FREQ            (8000000U)    

TIM_Base_InitTypeDef TIM_TimeBaseStructure;    
TIM_OC_InitTypeDef Tim_OC_Init_Para;  


void TIM2_Init(void)  
{
    __RCC_TIM2_CLK_ENABLE();  
    uint32_t timer_clock;    
    
    timer_clock = RCC_GetPCLK1Freq();     
    if (RCC_GetHCLKFreq() != timer_clock)  // if hclk/pclk != 1, then timer clk = pclk * 2  
    {
       timer_clock =  timer_clock << 1;    
    }
    
	TIM_TimeBaseStructure.ClockDivision = TIM_CLOCKDIVISION_DIV1; 
	TIM_TimeBaseStructure.CounterMode = TIM_COUNTERMODE_UP; 
	TIM_TimeBaseStructure.RepetitionCounter = 0;  
	TIM_TimeBaseStructure.Prescaler = (timer_clock/TIM_CLOCK_FREQ) - 1;  
    if (timer_clock%TIM_CLOCK_FREQ > TIM_CLOCK_FREQ/2) 
	{
		TIM_TimeBaseStructure.Prescaler = TIM_TimeBaseStructure.Prescaler + 1;  
	}
	TIM_TimeBaseStructure.Period = (TIM_CLOCK_FREQ/1000) - 1;  // period = 1ms, frequency = 1KHz         	    
	TIM_TimeBase_Init(TIM2, &TIM_TimeBaseStructure);        
    
	Tim_OC_Init_Para.OCMode = OUTPUT_MODE_PWM1;  
	Tim_OC_Init_Para.OCIdleState = OUTPUT_IDLE_STATE_0;
	Tim_OC_Init_Para.OCNIdleState = OUTPUT_IDLE_STATE_0;      
	Tim_OC_Init_Para.OCPolarity = OUTPUT_POL_ACTIVE_HIGH;  
	Tim_OC_Init_Para.OCNPolarity = OUTPUT_POL_ACTIVE_HIGH;    
	Tim_OC_Init_Para.OCFastMode =  OUTPUT_FAST_MODE_DISABLE;  
	Tim_OC_Init_Para.Pulse = (TIM_TimeBaseStructure.Period + 1)/2;   // 50% duty cycle   	
	TIM_OC3Init(TIM2, &Tim_OC_Init_Para);             
             
}

GPIO_InitTypeDef gpio_init;  
void GPIO_Configuration(void)  
{	
    __RCC_GPIOC_CLK_ENABLE();  
	gpio_init.Pin = GPIO_PIN_6;  //TIM2_CH3  
	gpio_init.Mode = GPIO_MODE_AF_PP;          
	gpio_init.Pull = GPIO_NOPULL;    
	gpio_init.Alternate = GPIO_FUNCTION_2;      
    gpio_init.Drive = GPIO_DRIVE_LEVEL3;  
	GPIO_Init(GPIOC, &gpio_init);    // PC6    
}
void COMP1_Init(void)
{
    __RCC_COMP_CLK_ENABLE();    
    COMP_InitTypeDef COMP1_handle;
    COMP1_handle.InPSel = COMP1_INPSEL_PA1;
    COMP1_handle.InMSel = COMP1_INMSEL_PA4;
    COMP1_handle.Polarity = COMP_POLARITY_NOINVERT;
    COMP1_handle.HYS = COMP_HYS_7;
    COMP1_handle.BlankSel = COMP1_BLANKSEL_TIM2_OC3;
    COMP1_handle.WinMode = COMP_WINMODE_SELF_INP;
    COMP1_handle.WinOut = COMP_WINOUT_DIRECT;
    COMP1_handle.FltEn = COMP_FLT_ENABLE;
    COMP1_handle.FltTime = COMP_FLTTIME_4CLK;
    
    COMP_Init(COMP1,&COMP1_handle);
}

void COMP_GPIO_Init(void)
{
    __RCC_GPIOA_CLK_ENABLE();
    //VINP:PA1, VINM:PA4, VOUT:PA0(AF6)
    GPIO_InitTypeDef GPIO_handle;
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_1;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_4;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_AF_PP;
    GPIO_handle.Pin = GPIO_PIN_0;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_handle.Alternate = GPIO_FUNCTION_6;
    GPIO_Init(GPIOA,&GPIO_handle);

}

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    printfS("COMP1 Test\r\n");
    GPIO_Configuration();
    
	TIM2_Init(); 
    
    TIM_CCxCmd(TIM2, TIM_CHANNEL_3, TIM_CCx_Enable);       
    /* TIM1 enable counter */    
    TIM_Cmd(TIM2, ENABLE);   
    
    /* Main Output Enable */  
    TIM_CtrlPWMOutputs(TIM2, ENABLE);   
    
    COMP_GPIO_Init();
    COMP1_Init();
    COMP_Cmd(COMP1,ENABLE);
    while(1)
    {
		Delay_Simple(500);
    };
}

