
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 


/******************************************************************************
* @brief : DAC output voltage initialization.
* @param : None.
* @return: None
******************************************************************************/
void DAC_Config_OutPut_Voltage()
{
    __RCC_DAC1_CLK_ENABLE();
    DAC_InitTypeDef sConfig; 
    sConfig.DAC_Trigger = DAC_TRIGGER_SOFTWARE;
    sConfig.DAC_Trigger2 = DAC_TRIGGER_SOFTWARE;
    sConfig.DAC_SampleAndHold = DAC_SAMPLEANDHOLD_DISABLE;
    sConfig.DAC_OutputBuffer = DAC_OUTPUTBUFFER_DISABLE;
    sConfig.DAC_ConnectOnChipPeripheral = DAC_CHIPCONNECT_INTERNAL;  
    sConfig.DAC_UserTrimming = DAC_TRIMMING_FACTORY;

    DAC_Init(DAC,DAC_CHANNEL_1, &sConfig); 


    /* ԶУ׼ɸҪ/ر */
    DACEx_SelfCalibrate(DAC, &sConfig,DAC_CHANNEL_1);

    Delay_Simple(500000);
}
/******************************************************************************
* @brief : DAC output voltage.
* @param : voltage output voltage value.
* @return: None
******************************************************************************/
void DAC_OutPutVoltage(float voltage)
{
    if( voltage > 3.3)
    {
        return;
    }
    uint16_t data=((voltage / 3.3) * 4095);
    DAC_SetDualChannelData(DAC,DAC_ALIGN_12B_R,data,data);
    DAC_Cmd(DAC, DAC_CHANNEL_1,ENABLE);
    DAC_SoftwareTriggerCmd(DAC, DAC_CHANNEL_1,ENABLE);

}
void COMP1_Init(void)
{
    __RCC_COMP_CLK_ENABLE();    
    COMP_InitTypeDef COMP1_handle;
    COMP1_handle.InPSel = COMP1_INPSEL_PA1;
    COMP1_handle.InMSel = COMP1_INMSEL_DAC1;
    COMP1_handle.Polarity = COMP_POLARITY_NOINVERT;
    COMP1_handle.HYS = COMP_HYS_7;
    COMP1_handle.BlankSel = COMP_BLANKSEL_NONE;
    COMP1_handle.WinMode = COMP_WINMODE_SELF_INP;
    COMP1_handle.WinOut = COMP_WINOUT_DIRECT;
    COMP1_handle.FltEn = COMP_FLT_ENABLE;
    COMP1_handle.FltTime = COMP_FLTTIME_4CLK;
    
    COMP_Init(COMP1,&COMP1_handle);
}

void COMP_GPIO_Init(void)
{
    __RCC_GPIOA_CLK_ENABLE();
    //VINP:PA1, VOUT:PA0(AF6)
    GPIO_InitTypeDef GPIO_handle;
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_1;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_AF_PP;
    GPIO_handle.Pin = GPIO_PIN_0;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_handle.Alternate = GPIO_FUNCTION_6;
    GPIO_Init(GPIOA,&GPIO_handle);

}

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    printfS("COMP1 Test\r\n");
    DAC_Config_OutPut_Voltage();
    DAC_OutPutVoltage(2.5);
    COMP_GPIO_Init();
    COMP1_Init();
    COMP_Cmd(COMP1,ENABLE);
    while(1)
    {
        printf("%x\r\n",GPIO_ReadPin(GPIOA,GPIO_PIN_0));
		Delay_Simple(500);
    };
}

