
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 
#include "spl_comp.h"


void COMP1_Init(void)
{
    __RCC_COMP_CLK_ENABLE();    
    COMP_InitTypeDef COMP1_handle;
    COMP1_handle.InPSel = COMP1_INPSEL_PA1;
    COMP1_handle.InMSel = COMP1_INMSEL_PA4;
    COMP1_handle.Polarity = COMP_POLARITY_NOINVERT;
    COMP1_handle.HYS = COMP_HYS_7;
    COMP1_handle.BlankSel = COMP_BLANKSEL_NONE;
    COMP1_handle.WinMode = COMP_WINMODE_SELF_INP;
    COMP1_handle.WinOut = COMP_WINOUT_DIRECT;
    COMP1_handle.FltEn = COMP_FLT_ENABLE;
    COMP1_handle.FltTime = COMP_FLTTIME_4CLK;
    
    COMP_Init(COMP1,&COMP1_handle);
}

void COMP_GPIO_Init(void)
{
    __RCC_GPIOA_CLK_ENABLE();
    //VINP:PA1, VINM:PA4, VOUT:PA0(AF6)
    GPIO_InitTypeDef GPIO_handle;
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_1;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_ANALOG;
    GPIO_handle.Pin = GPIO_PIN_4;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_Init(GPIOA,&GPIO_handle);
    
    GPIO_handle.Drive = GPIO_DRIVE_LEVEL3;
    GPIO_handle.Mode = GPIO_MODE_AF_PP;
    GPIO_handle.Pin = GPIO_PIN_0;
    GPIO_handle.Pull = GPIO_NOPULL;
    GPIO_handle.Alternate = GPIO_FUNCTION_6;
    GPIO_Init(GPIOA,&GPIO_handle);

}

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    printfS("COMP1 Test\r\n");
    COMP_GPIO_Init();
    COMP1_Init();
    COMP_Cmd(COMP1,ENABLE);
    while(1)
    {
		Delay_Simple(500);
    };
}

