
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"   

uint8_t test_data_buf[1024];

void test_data_init(void)
{
	uint32_t i;
	for(i = 0; i < 256; i++ )
	{
		test_data_buf[i] = i;
	}
}

uint16_t reverse_16(uint16_t in_data)
{
	uint16_t temp;
	uint8_t i;

	temp = 0;
	for(i = 0; i < 16; i++)
	{
		if(in_data & (1<<i))
		{
			temp |= 0x8000>>i;
		}
	}

	return temp;
}

uint16_t crc16_base_MSB(uint16_t crc,uint8_t data, uint16_t poly)
{
	uint8_t i;

	crc = crc ^ (uint16_t)data <<8;
	for(i=0;i<8;i++)
	{
		if((crc&0x8000) == 0x8000)
		{
			crc = crc << 1 ^ poly;
		}
		else
		{
			crc = crc << 1;
		}
	}
	return crc&0xffff;
}

uint16_t crc16_soft_MSB(uint8_t crc_data[], uint32_t len, uint16_t poly, uint16_t init_data, uint16_t result_xor)
{
	uint32_t i;
	uint16_t reg_crc;

	reg_crc = init_data;

	for( i = 0; i < len; i++ )
	{
		reg_crc = crc16_base_MSB(reg_crc,crc_data[i],poly);	
	}
	return (reg_crc^result_xor)&0xffff;
}

void APP_CRC_Test(void)
{
	uint32_t result1,result2;
	uint32_t poly,init,xor_out;
	uint32_t byte_len;

	CRC_HandleTypeDef handle_crc;

	test_data_init();
	
	poly = 0x1021;  //poly = x16+x12+x5+1
	init = 0xFFFF;
	xor_out = 0x0000;
	byte_len = 256;
	
	result1 = crc16_soft_MSB(test_data_buf,byte_len,poly,init,xor_out);	
	
	handle_crc.Instance = CRC;
	handle_crc.Init.PolyRev = CRC_POLY_REV_EN;      //need to be fixed to REV_EN
	handle_crc.Init.OutxorRev = CRC_OUTXOR_REV_EN;  //need to be fixed to REV_EN
	handle_crc.Init.InitRev = CRC_INIT_REV_EN;      //need to be fixed to REV_EN
	handle_crc.Init.RsltRev = CRC_RSLT_REV_EN;      //opposite to common CRC tools 
	handle_crc.Init.DataRev = CRC_DATA_REV_BY_BYTE; //opposite to common CRC tools
	handle_crc.Init.PolyLen = CRC_POLTY_LEN_16;
	handle_crc.Init.DataLen = CRC_DATA_LEN_1B;
	
	handle_crc.Init.PolyData = 0x1021;  //poly = x16+x12+x5+1(CRC-16/CCIT-FALSE)
	handle_crc.Init.InitData = 0xFFFF;
	handle_crc.Init.OutXorData = 0x0000;
	
	handle_crc.CRC_Data_Buff = test_data_buf;
	handle_crc.CRC_Data_Len = byte_len;
	
	result2 = CRC_Calculate(&handle_crc);
	
	printf("result1 = 0x%x\n", result1);
	printf("result2 = 0x%x\n", result2);
	
	if (result1 == result2)
	{
		printf("\nCRC test success\n");
	} 
	else
	{
		printf("CRC test fail\n");
	}			
}






