
/******************************************************************************
*@file  : acm32g103_it.c
*@brief : Main Interrupt Service Routines
*           This file provides template for all exceptions handler and 
*           peripherals interrupt service routine.  
******************************************************************************/

#include "app.h"
#include "acm32g103_it.h"


void NMI_Handler(void)
{   
}


void HardFault_Handler(void)
{
    while (1)
    {
    }
}


void MemManage_Handler(void)
{
    while (1)
    {
    }
}


void BusFault_Handler(void)
{
    while (1)
    {
    }
}


void UsageFault_Handler(void)
{
    while (1)
    {
    }
}


void SVC_Handler(void)
{
}


void DebugMon_Handler(void)
{
}


void PendSV_Handler(void)
{
}


/******************************************************************************
*@brief : System tick handler
*@param : none
*@return: none
******************************************************************************/
void SysTick_Handler(void)
{
	SysTick_Inc();
}


void EXTI15_10_IRQHandler(void)
{
    if (EXTI->PDR & EXTI_LINE_13)
    {
        EXTI->PDR = EXTI_LINE_13;
//        PB_IRQHandler();
    }
}

void DMA1_IRQHandler(void)
{
    if (DMA_GetFlagStatus(DMA1_Channel0,DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel0,DMA_FLAG_TC);
    }
    if (DMA_GetFlagStatus(DMA1_Channel0,DMA_FLAG_ERR))
    {
        DMA_ClearFlag(DMA1_Channel0,DMA_FLAG_ERR);
    }
    if (DMA_GetFlagStatus(DMA1_Channel1,DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel1,DMA_FLAG_TC);
    }
    if (DMA_GetFlagStatus(DMA1_Channel1,DMA_FLAG_ERR))
    {
        DMA_ClearFlag(DMA1_Channel1,DMA_FLAG_ERR);
    }
}
void TIM6_IRQHandler(void)
{
    TIM_ClearFlag(TIM6,TIMER_SR_UIF);
    TIM_Updeate_Event_Callback();   	
}