
/******************************************************************************
*@file  : main.c
*@brief : main program
******************************************************************************/

#include "main.h" 
#include "app.h"   

/******************************************************************************
*@brief : main program
*@param : none
*@return: none
******************************************************************************/
int main(void)
{
    RCC_ClocksTypeDef RCC_Clocks;
    
	#if (INS_ACCELERATE_ENABLE == 1)
//		System_EnableIAccelerate();
	#endif

	#if (DATA_ACCELERATE_ENABLE == 1)
		System_EnableDAccelerate();
	#endif     
    
	/* Set Interrupt Group Priority */
	NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
    
    SystemClock_Config();    
    
    SystemCoreClockUpdate();
    
    RCC_GetClocksFreq(&RCC_Clocks);
    
    SysTick_Config(RCC_Clocks.HCLK_Frequency / 1000);
    
    BSP_UART_Init();  
	
	printfS("\r\n\r\n");
	printfS("************************************************************\r\n\r\n");
	printfS("system startup\r\n");
	
	get_reset_source();
    BSP_MCO_Init();
    
	printfS("HCK: %u\r\n", RCC_GetHCLKFreq());
	printfS("PCLK1: %u\r\n", RCC_GetPCLK1Freq());
	printfS("PCLK2: %u\r\n", RCC_GetPCLK2Freq());
    printfS("\r\n");
	printfS("************************************************************\r\n\r\n");
    /*
    DAC_Output_Noise,
    DAC_Output_SAWTOOTH,
    DAC_OutPut_Voltage,   
    DAC_OutPut_Sinx,
    DAC_DMA_Output_Sinx,
    DAC_DMADUALDATA_Output_Sinx
    */
    APP_DAC_Demo(DAC_DMA_Output_Sinx);
}














