
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

#define    DMA_TRANSFER_BUF_SIZE    ( 1024U )

__attribute__ ((aligned (4)))	uint8_t g_src_buf[DMA_TRANSFER_BUF_SIZE];
__attribute__ ((aligned (4)))	uint8_t g_dest_buf[DMA_TRANSFER_BUF_SIZE];

DMA_InitTypeDef DMA_InitStruct = {0};

volatile uint32_t g_transfer_count;

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    uint32_t j;
    
	printfS("SPL DMA Demo: M2M Circular\r\n");
	printfS("\r\n");
    
	BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    __RCC_DMA1_CLK_ENABLE();
    DMA_DeInit(DMA1_Channel0);
    
    DMA_InitStruct.Mode        = DMA_MODE_CIRCULAR;
    DMA_InitStruct.DataFlow    = DMA_DATAFLOW_M2M;
    DMA_InitStruct.ReqID       = DMA1_REQ0_M2M;
    DMA_InitStruct.RawInt      = DMA_RAWINT_ENABLE;
    DMA_InitStruct.SrcWidth    = DMA_SRCWIDTH_BYTE;
    DMA_InitStruct.DestWidth   = DMA_DESTWIDTH_BYTE;
    DMA_InitStruct.SrcInc      = DMA_SRCINC_ENABLE;
    DMA_InitStruct.DestInc     = DMA_DESTINC_ENABLE;
    DMA_InitStruct.SrcBurst    = DMA_SRCBURST_1;
    DMA_InitStruct.DestBurst   = DMA_DESTBURST_1;
    
    DMA_InitStruct.SrcAddr     = (uint32_t)g_src_buf;
    DMA_InitStruct.DestAddr    = (uint32_t)g_dest_buf;
    DMA_InitStruct.Size        = DMA_TRANSFER_BUF_SIZE;
    
    DMA_Init(DMA1_Channel0, &DMA_InitStruct);
    
    for (i = 0; i < DMA_TRANSFER_BUF_SIZE; i++)
    {
        g_src_buf[i] = (uint8_t)i;
        g_dest_buf[i] = 0;
    }
    
    DMA_ClearFlag(DMA1_Channel0, DMA_FLAG_RTC);
    DMA_ITConfig(DMA1_Channel0, DMA_IT_TC | DMA_IT_ERR, ENABLE);
    
    NVIC_ClearPendingIRQ(DMA1_IRQn);
    NVIC_SetPriority(DMA1_IRQn, 0x00);
    NVIC_EnableIRQ(DMA1_IRQn);
    
	printfS("DMA Circular transmission, start.\r\n");
    
    g_transfer_count = 0;
    
    DMA_Cmd(DMA1_Channel0, ENABLE);
    
    while (1)
    {
        BSP_LED_Toggle();
        DelayMs(500);
        printfS("DMA circular transfer count: %u.\r\n", g_transfer_count);
    }
}

void DMA1CH0_Transfer_Complete(void)
{
    g_transfer_count++;
}

void DMA1CH0_Transfer_Error(void)
{
    g_transfer_count = 0;
}

