
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

#define    DMA_TRANSFER_BUF_SIZE    ( 12U )

__attribute__ ((aligned (4)))	uint8_t g_src_buf[DMA_TRANSFER_BUF_SIZE];
__attribute__ ((aligned (4)))	uint8_t g_dest_buf[DMA_TRANSFER_BUF_SIZE];

DMA_InitTypeDef DMA_InitStruct = {0};
    
/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    
	printfS("SPL DMA Demo: M2M Block\r\n");
	printfS("\r\n");
    
	BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    __RCC_DMA1_CLK_ENABLE();
    DMA_DeInit(DMA1_Channel0);
    
    DMA_InitStruct.Mode        = DMA_MODE_NORMAL;
    DMA_InitStruct.DataFlow    = DMA_DATAFLOW_M2M;
    DMA_InitStruct.ReqID       = DMA1_REQ0_M2M;
    DMA_InitStruct.RawInt      = DMA_RAWINT_ENABLE;
    DMA_InitStruct.SrcWidth    = DMA_SRCWIDTH_BYTE;
    DMA_InitStruct.DestWidth   = DMA_DESTWIDTH_BYTE;
    DMA_InitStruct.SrcInc      = DMA_SRCINC_ENABLE;
    DMA_InitStruct.DestInc     = DMA_DESTINC_ENABLE;
    DMA_InitStruct.SrcBurst    = DMA_SRCBURST_1;
    DMA_InitStruct.DestBurst   = DMA_DESTBURST_1;
    
    DMA_InitStruct.SrcAddr     = (uint32_t)g_src_buf;
    DMA_InitStruct.DestAddr    = (uint32_t)g_dest_buf;
    DMA_InitStruct.Size        = DMA_TRANSFER_BUF_SIZE;
    
    DMA_Init(DMA1_Channel0, &DMA_InitStruct);
    
    for (i = 0; i < DMA_TRANSFER_BUF_SIZE; i++)
    {
        g_src_buf[i] = (uint8_t)i;
        g_dest_buf[i] = 0;
    }
    
	printfS("DMA transmission, start.\r\n");
    
    DMA_ClearFlag(DMA1_Channel0, DMA_FLAG_RTC);
    DMA_Cmd(DMA1_Channel0, ENABLE);
    
    while (DMA_GetFlagStatus(DMA1_Channel0, DMA_FLAG_RTC) == RESET);
    DMA_ClearFlag(DMA1_Channel0, DMA_FLAG_RTC);
    
	printfS("DMA transfer completed.\r\n");
    
    if (memcmp((void *)g_src_buf, (void *)g_dest_buf, DMA_TRANSFER_BUF_SIZE) == 0)
    {
        printfS("Data comparison succeeded.\r\n");
    }
    else
    {
        printfS("Data comparison failed.\r\n");
    }
    
    while(1)
    {
        BSP_LED_Toggle();
		DelayMs(500);
    };
}

void PB_IRQHandler(void)
{
}

