
/******************************************************************************
*@file  : acm32g103_spl_conf.c
*@brief : HAL configuration file
******************************************************************************/

#ifndef __ACM32G103_SPL_CONF_H
#define __ACM32G103_SPL_CONF_H

#include "acm32g103.h"
#include "spl_def.h"

/******* enable printf in debug stage ****************************************/
#define DEBUG

#ifdef DEBUG
    #define printfS(fmt, ...)       printf(fmt, ##__VA_ARGS__)
#else
    #define printfS(fmt, ...)         
#endif

/******* enable assert in debug stage ****************************************/
#define USE_FULL_ASSERT

#ifdef USE_FULL_ASSERT
  void assert_failed(uint8_t* file, uint32_t line);
  #define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__))
#else
  #define assert_param(expr) ((void)0U)
#endif

 /******* config data if or not in extern sram *******************************/ 
//#define DATA_IN_ExtSRAM
  

/******* config extern high speed osc freq and low osc freq in Hz ************/
#define XTH_VALUE                   ( 12000000U )
#define XTL_VALUE                   ( 32768U )


/******* SysTick interrupt priority  *****************************************/
#define TICK_INT_PRIORITY           ((1<<__NVIC_PRIO_BITS)-1)  

/******* SysTick ms period set ,1ms or 10ms **********************************/
#define TICK_PERIOD_1MS             (1U)
#define TICK_PERIOD_10MS            (10U)
#define TICK_PERIOD_MS              (TICK_PERIOD_1MS)  


/******* instruction and data accelerate enable ******************************/
#define INS_ACCELERATE_ENABLE       (1U)    //instruction accelerate enable 
#define DATA_ACCELERATE_ENABLE      (0U)    //data accelerate enable

/******* module selection ****************************************************/

    
#if ((INS_ACCELERATE_ENABLE==1) ||  (DATA_ACCELERATE_ENABLE==1))
    #include "system_accelerate.h"
#endif  
    
    #include "spl_misc.h"
//    #include "spl_exmc.h"
    #include "spl_dma.h"
    #include "spl_gpio.h"
    #include "spl_uart.h"
//    #include "spl_uart_ex.h"
//    #include "spl_adc.h"
//    #include "spl_dac.h"
    #include "spl_exti.h"
//    #include "spl_i2c.h"
//    #include "spl_i2s.h"
    #include "spl_rcc.h"
//    #include "spl_rtc.h"
//	#include "spl_pmu.h"
//    #include "spl_spi.h"
//    #include "spl_iwdt.h"
    #include "spl_eflash.h"
//    #include "spl_opa.h"
//    #include "spl_comp.h"
//    #include "spl_can.h"
//    #include "spl_lpuart.h"
//    #include "spl_wdt.h"
//    #include "spl_timer.h"  
//    #include "spl_timer_ex.h"
//    #include "spl_fsusb.h"
//    #include  "spl_crc.h"
//    #include  "spl_aes.h"
//    #include  "spl_fau.h"
//    #include "spl_sha1.h"
//    #include "spl_sha256.h"
//    #include "spl_hrng.h"
//    #include "spl_lptim.h"





#endif /* __ACM32G103_SPL_CONF_H  */

  