
/******************************************************************************
*@file  : app.c
*@brief : application
*@ver   : 1.0.0
*@date  : 2022.10.20
******************************************************************************/

#include "app.h"   
#include "main.h"

#define EFLASH_TEST_ADDR (0x10000)
#define BUFFER_LENGTH    (512*40)

__ALIGNED(8)  uint8_t g_txBuffer[BUFFER_LENGTH];
__ALIGNED(8)  uint8_t g_rxBuffer[BUFFER_LENGTH];


void APP_Test(void)
{
    uint8_t ret;
    int i;
    uint32_t starttick,delay;
    uint32_t errorCount=0;
    

    printfS("\r\neflash test,addr:%d, size : %d KB\r\n",EFLASH_TEST_ADDR, BUFFER_LENGTH/1024);
  
#if 1
    
    //ɱ
    for(i=0;i<BUFFER_LENGTH;i++)
    {
        g_txBuffer[i]=i+102;
    }

    
    //FLASH    
    starttick=SysTick_Get();    
    ret = EFLASH_Erase(EFLASH_TEST_ADDR,BUFFER_LENGTH); 
    delay = SysTick_Get()-starttick;
    printfS("erase time:%d ms\r\n",delay); 
    if(ret!=EFLASH_COMPLETE)
       printfS("erase operation fail\r\n");   
    
    //Ƿɹ    
    EFLASH_Read(EFLASH_TEST_ADDR,g_rxBuffer, BUFFER_LENGTH);       
    for(i=0;i<BUFFER_LENGTH;i++)
    {
        if(0xff!=g_rxBuffer[i])
            break;
    } 
    if(i!=BUFFER_LENGTH)
        printfS("erase check fail\r\n"); 
    else
        printfS("erase ok\r\n");     
    
    //FLASH    
    starttick=SysTick_Get(); 
    ret = EFLASH_ProgramWords(EFLASH_TEST_ADDR,g_txBuffer,BUFFER_LENGTH/4); 
    delay = SysTick_Get()-starttick;
    printfS("program time:%d ms\r\n",delay);
    
     if(ret!=EFLASH_COMPLETE)
        printfS("program operation fail\r\n");
     
    //Ƿ̳ɹ 
    starttick=SysTick_Get();      
    EFLASH_Read(EFLASH_TEST_ADDR,g_rxBuffer, BUFFER_LENGTH);   
    delay = SysTick_Get() - starttick;
    printfS("read time:%d ms\r\n",delay);
    
    errorCount=0;
    for(i=0;i<BUFFER_LENGTH;i++)
    {
        if(g_txBuffer[i]!=g_rxBuffer[i])
        {
            printfS("error offset:%d,read:%02x,should:%02x,\r\n",i,g_rxBuffer[i],g_txBuffer[i]);
            errorCount++;
        }
        if(errorCount>100)
        {
            break;
        }
    } 
    if(i!=BUFFER_LENGTH)
        printfS("program check fail\r\n"); 
    else
        printfS("program ok\r\n"); 
    
#endif 

#if 1  
    
    //ɱ
    for(i=0;i<BUFFER_LENGTH;i++)
    {
        g_txBuffer[i]=i+201;
    } 
    
    //ݲ
    
    starttick=SysTick_Get(); 
    ret = EFLASH_BackupEraseProgram(EFLASH_TEST_ADDR,g_txBuffer,BUFFER_LENGTH);  
    delay = SysTick_Get() - starttick;    
    printfS("backup erase program time:%d ms\r\n",delay);
    
    if(ret!=EFLASH_COMPLETE)
        printfS("backup erase program operation fail\r\n");
    
    starttick=SysTick_Get();       
    EFLASH_Read(EFLASH_TEST_ADDR,g_rxBuffer, BUFFER_LENGTH);
    delay = SysTick_Get() - starttick;
    printfS("read time:%d ms\r\n",delay);
    
    for(i=0;i<BUFFER_LENGTH;i++)
    {
        if(g_txBuffer[i]!=g_rxBuffer[i])
            break;
    } 
    if(i!=BUFFER_LENGTH)
        printfS("backup erase program check fail\r\n"); 
    else
        printfS("backup erase program ok\r\n");     
 #endif     

}