
/******************************************************************************
*@file  : main.c
*@brief : main program
******************************************************************************/

#include "main.h" 
#include "app.h"   

/******************************************************************************
*@brief : main program
*@param : none
*@return: none
******************************************************************************/
int main(void)
{
    RCC_ClocksTypeDef RCC_Clocks;
    
	#if (INS_ACCELERATE_ENABLE == 1)
		System_EnableIAccelerate();
	#endif

	#if (DATA_ACCELERATE_ENABLE == 1)
		System_EnableDAccelerate();
	#endif     
    
	/* Set Interrupt Group Priority */
	NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
    
    SystemClock_Config();    
    
    SystemCoreClockUpdate();
    
    RCC_GetClocksFreq(&RCC_Clocks);
    
    SysTick_Config(RCC_Clocks.HCLK_Frequency / 1000);
    
    BSP_UART_Init();  

#if 0
    if(EFLASH_EnableJtag()==EFLASH_COMPLETE)
    {
        printfS("ʹJTAGɹ\r\n");
    }
    else
    {
        printfS("ʹJTAGʧ\r\n");        
    }
#endif	
    
#if 0
    if(EFLASH_DisableJtag()==EFLASH_COMPLETE)
    {
        printfS("ֹJTAGɹ\r\n");
    }
    else
    {
        printfS("ֹJTAGʧ\r\n");        
    }    
#endif	
    APP_Test();
    
    while(1)
    {
        
    }
}














