
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

void EnterStopMode(void);

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
	printfS("SPL EXTI Demo\r\n");
	printfS("\r\n");
	printfS("The user presses the key to wake up from STOP.\r\n");
	printfS("\r\n");
    
	BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    BSP_PB_Init();
    
    PMU_Init();
    while(1)
    {
        printfS("mcu enter stop mode!\r\n"); 
        printfS("Press the key to exit stop mode!\r\n"); 
        
        EnterStopMode();
        
		printfS("mcu has exited stop mode!\r\n");
		printfS("\r\n");
        
		DelayMs(500);
    };
}

void PB_IRQHandler(void)
{
    BSP_LED_Toggle();
}

void EnterStopMode(void)
{
	volatile uint32_t i;
    uint32_t primask;
          
    primask = __get_PRIMASK();
    __set_PRIMASK(1);    // disable interrupt 
    SysTick_Suspend();
    SCB->ICSR = BIT25;   // clear systick pending bit 
    
    RCC_RC32KCmd(ENABLE);
    RCC_SYSCLKConfig(RCC_SYSCLKSOURCE_RC32K);
    
    PMU_EnterSTOPMode(PMU_STOP_2, PMU_LOWPOWRENTRY_WFI);
    
    SysTick_Resume();   
    
    __set_PRIMASK(primask);
    
    SystemClock_Config();    
    
    SystemCoreClockUpdate();
    
    BSP_UART_Init();  
	
}


