/*
  ******************************************************************************
  * @file    APP.c
  * @author  PJ
  * @version V1.0.0
  * @date    2021
  * @brief   UART demo source code.
  ******************************************************************************
*/
#include  "app.h"

BULK_IO_REQUEST bulk_io_request;
uint32_t g_bulk_ack = 0x53425355;  
uint8_t g_usb_data_buffer[1024];   

void USB_CMD_proc(void)
{
	uint32_t length;
	uint8_t  g_io_phase;

   	length = FSUSB_Get_FIFO_Length(out_ep_index);  

	/*-----------cmd stage-- CMD with 8 bytes ------------*/   
 	if(length!=8)	
	{
		printfS("fifo length==%d \n", length);

		FSUSB_Clear_FIFO(in_ep_index);    

		USBCTRL->EPxCSR[out_ep_index] |= 1<<11; //set rx ready 	
		return;
	}	
	else
	{            
        FSUSB_Read_EP_MEM8((uint8_t *)(&bulk_io_request), 8, 0, out_ep_index);	
		USBCTRL->EPxCSR[out_ep_index] |= 1<<11; //set rx ready to wait next packet 
	}

	length= (bulk_io_request.Length[2]<<16) + (bulk_io_request.Length[1]<<8) + (bulk_io_request.Length[0]);
	g_io_phase = bulk_io_request.BulkIoPhase;

	/*-----------data stage--------------*/
	if(g_io_phase==BulkIoPhase_Out)	  
	{	   
		printfS("usb data out \n");

		FSUSB_Receive_Data(g_usb_data_buffer,length,out_ep_index); 
				
   	}
	else if(g_io_phase==BulkIoPhase_In)	  
	{
		printfS("usb data in \n");

	   	FSUSB_Send_Data(g_usb_data_buffer,length,in_ep_index);    
	}  	
	
	/*-----------ACK stage--------------*/
	printfS("return ACK \n");	
	 
	FSUSB_Send_Data((uint8_t *)&g_bulk_ack,4,in_ep_index);    

}      



