
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

volatile uint32_t g_press;

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t state;
    
	printfS("SPL GPIO Demo\r\n");
	printfS("\r\n");
	printfS("LED flashing frequency: 1Hz.\r\n");
	printfS("The user presses the key to stop flashing, press the key again, and flash again.\r\n");
	printfS("\r\n");
    
    g_press = 0;
    
	BSP_LED_Init();
    
    BSP_PB_Init();
    
    state = 0;
    while(1)
    {
        if (g_press != 0)
        {
            DelayMs(50);
            g_press = 0;
            if (state == 0)
                state = 1;
            else
                state = 0;
        }
        
        if (state == 0)
        {
            BSP_LED_Toggle();
        }
        else
        {
            BSP_LED_Off();
        }
		DelayMs(500);
    };
}

void PB_IRQHandler(void)
{
    g_press = 1;
}

