
/******************************************************************************
*@file  : acm32g103_it.c
*@brief : Main Interrupt Service Routines
*           This file provides template for all exceptions handler and 
*           peripherals interrupt service routine.  
******************************************************************************/

#include "app.h"
#include "acm32g103_it.h"
#include "spl_i2c.h"

void NMI_Handler(void)
{   
}


void HardFault_Handler(void)
{
    while (1)
    {
    }
}


void MemManage_Handler(void)
{
    while (1)
    {
    }
}


void BusFault_Handler(void)
{
    while (1)
    {
    }
}


void UsageFault_Handler(void)
{
    while (1)
    {
    }
}


void SVC_Handler(void)
{
}


void DebugMon_Handler(void)
{
}


void PendSV_Handler(void)
{
}


/******************************************************************************
*@brief : System tick handler
*@param : none
*@return: none
******************************************************************************/
void SysTick_Handler(void)
{
	SysTick_Inc();
}

extern I2C_Handler_t hi2c;
void I2C1_IRQHandler(void)
{
    I2C_IRQHandler(I2C1, &hi2c);
}

void I2C2_IRQHandler(void)
{
    I2C_IRQHandler(I2C2, &hi2c);
}

void DMA1_IRQHandler(void)
{
    extern volatile bool TX_DMA_Status;
    if(DMA_GetFlagStatus(DMA1_Channel0, DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel0, DMA_FLAG_TC);
        //TX_DMA_Status = true;
    }
    
    if(DMA_GetFlagStatus(DMA1_Channel1, DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel1, DMA_FLAG_TC);
        TX_DMA_Status = true;
    }
}
