
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t curr_tick;
    uint32_t end_tick;
    uint32_t period;
    
	printfS("SPL IWDT Demo: period refresh\r\n");
	printfS("\r\n");
    
    BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    // RC32K
    RCC_RC32KCmd(ENABLE);
    if (RCC_WaitForRC32KStartUp() == ERROR)
    {
        printfS("RC32K stabilization timeout.\r\n");
        while (1);
    }
    
    __RCC_IWDTRSTTOSYSRST_ENABLE();
    
    IWDT_Enable();
    IWDT_WriteAccessCmd(ENABLE);
    
    while (IWDT_GetFlagStatus(IWDT_FLAG_PVU));
    IWDT_SetPrescaler(IWDT_CLOCK_PRESCALER_4);
    
    while (IWDT_GetFlagStatus(IWDT_FLAG_RVU));
    IWDG_SetReload(4000);
    
    IWDT_ReloadCounter();
    
    curr_tick = SysTick_Get();
    
    period = (uint32_t)4000 * 1000 / (RCC_GetRC32KFreq() / 4);
    
    printfS("IWDT refresh period : %u ms.\r\n", period);
    printfS("If the IWDT refresh fails, the system will be reset.\r\n");
    printfS("\r\n");
    
    end_tick = curr_tick + period - 20; 
    
    while(1)
    {
        curr_tick = SysTick_Get();
        if (curr_tick >= end_tick)
        {
            IWDT_ReloadCounter();
            
            BSP_LED_Toggle();
            
            printfS("IWDT refresh succeeded, The current TICK is %u ms, and the TICK interval is %u ms.\r\n", \
                          curr_tick, curr_tick - (end_tick - (period - 20)));
            
            end_tick += period - 20;
            
        }
    };
}


