
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

#define LPUART1_BUF_SIZE        ( 128U )

volatile uint8_t g_buf[LPUART1_BUF_SIZE];
volatile uint32_t g_top;
volatile uint32_t g_bot;

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    uint32_t data;
    uint32_t top;
    uint32_t bot;
    GPIO_InitTypeDef  GPIO_InitStruct = {0};
    LPUART_InitTypeDef LPUART_InitStruct = {0};
    
	printfS("SPL LPUART1 Demo: IT Mode.\r\n");
	printfS("\r\n");
    
	BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    // Init LPUART1
    __RCC_LPUART1_CLK_ENABLE();
    __RCC_LPUART1_RESET();
    
    // TX:PC1, RX:PC0
    __RCC_GPIOC_CLK_ENABLE();
    
    GPIO_InitStruct.Pin       = GPIO_PIN_1 | GPIO_PIN_0;
    GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
    GPIO_InitStruct.Pull      = GPIO_PULLUP;
    GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
    GPIO_InitStruct.Alternate = GPIO_FUNCTION_0;

    GPIO_Init(GPIOC, &GPIO_InitStruct);
    
    LPUART_SetClockSource(LPUART1, LPUART_CLOCKSOURCE_PCLK_DIV4);
    LPUART_SetWakeupMode(LPUART1, LPUART_WAKEUPMODE_NONE);
    
    LPUART_InitStruct.BaudRate    = 115200;
    LPUART_InitStruct.WordLength  = LPUART_WORDLENGTH_8B;
    LPUART_InitStruct.StopBits    = LPUART_STOPBITS_1B;
    LPUART_InitStruct.Parity      = LPUART_PARITY_NONE;
    LPUART_InitStruct.Mode        = LPUART_MODE_TXRX;
    
    LPUART_Init(LPUART1, &LPUART_InitStruct);
    
    memset((void *)g_buf, 0, LPUART1_BUF_SIZE);
    g_top = 0;
    g_bot = 0;
    
    LPUART_ITConfig(LPUART1, LPUART_IT_RX, ENABLE);
    
    // Enable NVIC IRQ
    NVIC_ClearPendingIRQ(LPUART1_IRQn);
    NVIC_SetPriority(LPUART1_IRQn, 0x00);
    NVIC_EnableIRQ(LPUART1_IRQn);
    
    printfS("LPUART1 : 115200, 8, 1, N.\r\n");
    printfS("LPUART1 receives data and sends back the received data.\r\n");
    
    while (1)
    {
        BSP_LED_Toggle();
        DelayMs(500);
    }
}

void lpuart1_irq_handle(void)
{
    if (LPUART_GetITStatus(LPUART1, LPUART_IT_RX))
    {
        g_buf[g_top++] = LPUART_ReceiveData(LPUART1);
        if (g_top >= LPUART1_BUF_SIZE)
            g_top = 0;
        
        LPUART_ITConfig(LPUART1, LPUART_IT_TXE, ENABLE);
    }
    
    if (LPUART_GetITStatus(LPUART1, LPUART_IT_TXE))
    {
        if (g_top != g_bot)
        {
            LPUART_SendData(LPUART1, g_buf[g_bot++]);
            if (g_bot >= LPUART1_BUF_SIZE)
                g_bot = 0;
        }
        else
        {
            LPUART_ITConfig(LPUART1, LPUART_IT_TXE, DISABLE);
        }
    }
    
}
