
/******************************************************************************
*@file  : acm32g103_spl_conf.c
*@brief : HAL configuration file
******************************************************************************/

#ifndef __ACM32G103_SPL_CONF_H
#define __ACM32G103_SPL_CONF_H

#include "acm32g103.h"
#include "spl_def.h"

/******* enable printf in debug stage ****************************************/
#define DEBUG

#ifdef DEBUG
    #define printfS(fmt, ...)       printf(fmt, ##__VA_ARGS__)
#else
    #define printfS(fmt, ...)         
#endif

/******* enable assert in debug stage ****************************************/
#define USE_FULL_ASSERT

#ifdef USE_FULL_ASSERT
  void assert_failed(uint8_t* file, uint32_t line);
  #define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__))
#else
  #define assert_param(expr) ((void)0U)
#endif

 /******* config data if or not in extern sram *******************************/ 
//#define DATA_IN_ExtSRAM
  

/******* config extern high speed osc freq and low osc freq in Hz ************/
#define XTH_VALUE                   ( 12000000U )
#define XTL_VALUE                   ( 32768U )


/******* SysTick interrupt priority  *****************************************/
#define TICK_INT_PRIORITY           ((1<<__NVIC_PRIO_BITS)-1)  

/******* SysTick ms period set ,1ms or 10ms **********************************/
#define TICK_PERIOD_1MS             (1U)
#define TICK_PERIOD_10MS            (10U)
#define TICK_PERIOD_MS              (TICK_PERIOD_1MS)  


/******* instruction and data accelerate enable ******************************/
#define INS_ACCELERATE_ENABLE       (1U)    //instruction accelerate enable 
#define DATA_ACCELERATE_ENABLE      (0U)    //data accelerate enable

/******* module selection ****************************************************/

    
#if ((INS_ACCELERATE_ENABLE==1) ||  (DATA_ACCELERATE_ENABLE==1))
    #include "system_accelerate.h"
#endif  
    
    #include "spl_misc.h"
//    #include "spl_exmc.h"
    #include "spl_dma.h"
    #include "spl_gpio.h"
    #include "spl_uart.h"
//    #include "spl_uart_ex.h"
//    #include "spl_adc.h"
//    #include "spl_dac.h"
    #include "spl_exti.h"
//    #include "spl_i2c.h"
//    #include "spl_i2s.h"
    #include "spl_rcc.h"
//    #include "spl_rtc.h"
//	#include "spl_pmu.h"
//    #include "spl_spi.h"
//    #include "spl_iwdt.h"
    #include "spl_eflash.h"
    #include "spl_opa.h"
//    #include "spl_comp.h"
//    #include "spl_can.h"
//    #include "spl_lpuart.h"
//    #include "spl_wdt.h"
//    #include "spl_timer.h"  
//    #include "spl_timer_ex.h"
//    #include "spl_fsusb.h"
//    #include  "spl_crc.h"
//    #include  "spl_aes.h"
//    #include  "spl_fau.h"
//    #include "spl_sha1.h"
//    #include "spl_sha256.h"
//    #include "spl_hrng.h"
//    #include "spl_lptim.h"




#define EFLASH_MAIN_ADDR                    EFLASH_BASE_ADDR
#define EFLASH_MAIN_SIZE                    (0x50000UL)

#define EFLASH_NVR_ADDR                     (EFLASH_BASE_ADDR+0x80000)
#define EFLASH_NVR_SIZE                     (EFLASH_PAGE_SIZE * 8)

#define EFLASH_NVR1_ADDR                    (EFLASH_NVR_ADDR+0x00000)
#define EFLASH_NVR2_ADDR                    (EFLASH_NVR_ADDR+0x00200)
#define EFLASH_NVR3_ADDR                    (EFLASH_NVR_ADDR+0x00400)
#define EFLASH_NVR4_ADDR                    (EFLASH_NVR_ADDR+0x00600)
#define EFLASH_NVR5_ADDR                    (EFLASH_NVR_ADDR+0x00800)
#define EFLASH_NVR6_ADDR                    (EFLASH_NVR_ADDR+0x00a00)
#define EFLASH_NVR7_ADDR                    (EFLASH_NVR_ADDR+0x00c00)
#define EFLASH_NVR8_ADDR                    (EFLASH_NVR_ADDR+0x00e00)


/***************  addr definition for EFLASH_NVR1 region  *******************/

#define EFLASH_NVR_OTP1_EN_ADDR             (EFLASH_NVR_ADDR + 0x1FC)

/***************  addr definition for EFLASH_NVR2 region  *******************/

#define EFLASH_NVR_DFT_DIS_ADDR             (EFLASH_NVR_ADDR + 0x200)
#define EFLASH_NVR_BUS_CRYPT_EN_ADDR        (EFLASH_NVR_ADDR + 0x204)
#define EFLASH_NVR_UID0_ADDR                (EFLASH_NVR_ADDR + 0x208)
#define EFLASH_NVR_UID1_ADDR                (EFLASH_NVR_ADDR + 0x20C)
#define EFLASH_NVR_UID2_ADDR                (EFLASH_NVR_ADDR + 0x210)
#define EFLASH_NVR_UID3_ADDR                (EFLASH_NVR_ADDR + 0x214)
#define EFLASH_NVR_UID_CRC_ADDR             (EFLASH_NVR_ADDR + 0x218)
#define EFLASH_NVR_JTAG_DIS_ADDR            (EFLASH_NVR_ADDR + 0x21C)
#define EFLASH_NVR_CFG_DENSITY_ADDR         (EFLASH_NVR_ADDR + 0x220)
#define EFLASH_NVR_RC64M_TRIM_ADDR          (EFLASH_NVR_ADDR + 0x228)
#define EFLASH_NVR_RC64M_VAL_ADDR           (EFLASH_NVR_ADDR + 0x22C)
#define EFLASH_NVR_RC32K_VAL_ADDR           (EFLASH_NVR_ADDR + 0x230)
#define EFLASH_NVR_LDO_TRIM_ADDR            (EFLASH_NVR_ADDR + 0x234)
#define EFLASH_NVR_LDO_TRIM_NOT_ADDR        (EFLASH_NVR_ADDR + 0x238)
#define EFLASH_NVR_RC32K_TRIM_ADDR          (EFLASH_NVR_ADDR + 0x23C)
#define EFLASH_NVR_ADC_1V2_VAL_ADDR         (EFLASH_NVR_ADDR + 0x240)
#define EFLASH_NVR_ADC_VREFBI_VTRIM_ADDR    (EFLASH_NVR_ADDR + 0x244)
#define EFLASH_NVR_DAC_CAL_OS_ADDR          (EFLASH_NVR_ADDR + 0x248)
#define EFLASH_NVR_OPA1_CAL_OSPN_ADDR       (EFLASH_NVR_ADDR + 0x24C)
#define EFLASH_NVR_OPA2_CAL_OSPN_ADDR       (EFLASH_NVR_ADDR + 0x250)
#define EFLASH_NVR_OPA3_CAL_OSPN_ADDR       (EFLASH_NVR_ADDR + 0x254)
#define EFLASH_NVR_CHIP_VERSION_ADDR        (EFLASH_NVR_ADDR + 0x268)
#define EFLASH_NVR_CP1_2_FLAG_ADDR          (EFLASH_NVR_ADDR + 0x270)
#define EFLASH_NVR_BOOT_CLK_DIV_ADDR        (EFLASH_NVR_ADDR + 0x28C)
#define EFLASH_NVR_UART_AUTOBAND_EN_ADDR    (EFLASH_NVR_ADDR + 0x2B8)
#define EFLASH_NVR_USB_BOOT_EN_ADDR         (EFLASH_NVR_ADDR + 0x2BC)
#define EFLASH_NVR_CP3_FLASH_CP_ADDR        (EFLASH_NVR_ADDR + 0x2C4)
#define EFLASH_NVR_CHIP_MODEL_H_ADDR        (EFLASH_NVR_ADDR + 0x2D0)
#define EFLASH_NVR_CHIP_MODEL_L_ADDR        (EFLASH_NVR_ADDR + 0x2D4)
#define EFLASH_NVR_CFG_IP1_ADDR             (EFLASH_NVR_ADDR + 0x300)
#define EFLASH_NVR_CFG_IP2_ADDR             (EFLASH_NVR_ADDR + 0x304)
#define EFLASH_NVR_ROM_JTAG_DIS_ADDR        (EFLASH_NVR_ADDR + 0x304)
#define EFLASH_NVR_CFG_IP3_ADDR             (EFLASH_NVR_ADDR + 0x30C)
#define EFLASH_NVR_TRIM0_L_ADDR             (EFLASH_NVR_ADDR + 0x380)
#define EFLASH_NVR_TRIM0_H_ADDR             (EFLASH_NVR_ADDR + 0x384)
#define EFLASH_NVR_TRIM1_L_ADDR             (EFLASH_NVR_ADDR + 0x388)
#define EFLASH_NVR_TRIM1_H_ADDR             (EFLASH_NVR_ADDR + 0x38C)
#define EFLASH_NVR_TRIM2_L_ADDR             (EFLASH_NVR_ADDR + 0x390)
#define EFLASH_NVR_TRIM2_H_ADDR             (EFLASH_NVR_ADDR + 0x394)
#define EFLASH_NVR_OTP2_EN_ADDR             (EFLASH_NVR_ADDR + 0x3FC)

/***************  addr definition for EFLASH_NVR3 region: user region *******/

#define EFLASH_NVR_REMAP_ADDR               (EFLASH_NVR_ADDR + 0x400)
#define EFLASH_NVR_JTAG_DIS_2_ADDR          (EFLASH_NVR_ADDR + 0x41C)
#define EFLASH_NVR_CODE_CRC16_ADDR          (EFLASH_NVR_ADDR + 0x458)
#define EFLASH_NVR_CODE_LEN_ADDR            (EFLASH_NVR_ADDR + 0x45C)
#define EFLASH_NVR_CODE_START_ADDR          (EFLASH_NVR_ADDR + 0x460)
#define EFLASH_NVR_CODE_VALID_ADDR          (EFLASH_NVR_ADDR + 0x478)
#define EFLASH_NVR_ERASE_SRAM_EN_ADDR       (EFLASH_NVR_ADDR + 0x47C)

/***************  addr definition for EFLASH_NVR4 region  *******************/
                                                               
#define EFLASH_NVR_PCROP_EN_ADDR            (EFLASH_NVR_ADDR + 0x600)
#define EFLASH_NVR_PCROP_AREA_A_ADDR        (EFLASH_NVR_ADDR + 0x604)
#define EFLASH_NVR_PCROP_AREA_B_ADDR        (EFLASH_NVR_ADDR + 0x608)
#define EFLASH_NVR_WRP_EN_ADDR              (EFLASH_NVR_ADDR + 0x620)
#define EFLASH_NVR_WRP_AREA_A_ADDR          (EFLASH_NVR_ADDR + 0x624)
#define EFLASH_NVR_WRP_AREA_B_ADDR          (EFLASH_NVR_ADDR + 0x628)
#define EFLASH_NVR_SEC_SIZE_VALID_ADDR      (EFLASH_NVR_ADDR + 0x640)
#define EFLASH_NVR_SEC_SIZE_ADDR            (EFLASH_NVR_ADDR + 0x644)
#define EFLASH_NVR_RDP1_EN_ADDR             (EFLASH_NVR_ADDR + 0x660)
#define EFLASH_NVR_OTP4_EN_ADDR             (EFLASH_NVR_ADDR + 0x7FC)




#endif /* __ACM32G103_SPL_CONF_H  */

  