
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 


/******************************************************************************
* @brief : Set BOR Reset Wakeup.
* @param : None
* @return: None
******************************************************************************/
void BOR_Init(void)
{
    //BORѹѡ
    PMU_BORVoltageConfig(PMU_BORVOLTAGE_2V77_2V9);
    //BORλʹ
    PMU_BORResetCmd(ENABLE);
    //BORʹ
    PMU_BORCmd(ENABLE);
}

/******************************************************************************
* @brief : Enter Standby.
* @param : None
* @return: None
******************************************************************************/
void Standby_Mode(void)
{
    printfS("MCU enter standby mode \r\n");  
    SysTick->CTRL &= ~SysTick_CTRL_TICKINT_Msk;   // disable systick        
    __set_PRIMASK(1);    // disable interrupt 
    SCB->ICSR = BIT25;   // clear systick pending bit
    
    PMU_EnterSTANDBYMode(PMU_LOWPOWRENTRY_WFI);
    
    SysTick->CTRL |= SysTick_CTRL_TICKINT_Msk; /* Enable SysTick IRQ */               
    __set_PRIMASK(0);    // enable interrupt 
    while(1)
    {
        printfS("MCU never run here \r\n");
    }
}

/******************************************************************************
* @brief : Low power standby test.
* @param : None
* @return: none
******************************************************************************/
void APP_LowPower_Standby_Mode_Test(void)
{
    FlagStatus result = RESET;
    
    PMU_Init();
    
    result = PMU_GetFlagStatus(PMU_FLAG_SB);
    
    if(result == SET)
    {
        printfS("MCU has entered standby mode!\n");
    }

    printfS("MCU Standby wakeup by BOR Reset Test \r\n"); 
    
    result = PMU_GetFlagStatus(PMU_FLAG_BOR);
    if(result == SET)
    {
        printfS("WakeUp by BOR Reset \n");
        PMU_ClearFlag(PMU_SR_WUPFX_2);
    }
        
    DelayMs(5000);
    
    BOR_Init();
    
    Standby_Mode();
  
}

