
/******************************************************************************
*@file  : acm32g103_it.c
*@brief : Main Interrupt Service Routines
*           This file provides template for all exceptions handler and 
*           peripherals interrupt service routine.  
******************************************************************************/

#include "app.h"
#include "acm32g103_it.h"


void NMI_Handler(void)
{   
}


void HardFault_Handler(void)
{
    while (1)
    {
    }
}


void MemManage_Handler(void)
{
    while (1)
    {
    }
}


void BusFault_Handler(void)
{
    while (1)
    {
    }
}


void UsageFault_Handler(void)
{
    while (1)
    {
    }
}


void SVC_Handler(void)
{
}


void DebugMon_Handler(void)
{
}


void PendSV_Handler(void)
{
}


/******************************************************************************
*@brief : System tick handler
*@param : none
*@return: none
******************************************************************************/
void SysTick_Handler(void)
{
	SysTick_Inc();
}


void STOP_RESET_IRQHandler(void)
{
    NVIC_ClearPendingIRQ(RTC_IRQn);
    RCC->RSR |= BIT16;//иλ־
    PMU_ClearFlag(PMU_FLAG_ALL);//лѱ־
}


void EXTI15_10_IRQHandler(void)
{
    if (SET == EXTI_GetITStatus(EXTI_LINE_13))
    {
        EXTI_ClearITPendingBit(EXTI_LINE_13);
        //printfS("EXTI IRQ, EXTI_LINE_13\r\n");
    }
}


void LVD_IRQHandler(void)
{
    printfS("LVD IRQ, EXTI->PDR = 0x%08x\r\n",EXTI->PDR);
    EXTI->PDR |= EXTI_LINE_LVD;
}

