
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h"


/******************************************************************************
* @brief : LVD IRQ Init.
* @param : None
* @return: None
******************************************************************************/
void LVD_IRQ_Init(void)
{
    EXTI_InitTypeDef EXTI_InitStruct;
    __RCC_EXTI_CLK_ENABLE();
    /* Config EXTI */
    EXTI_InitStruct.GPIOx = NULL;
    EXTI_InitStruct.Line = EXTI_LINE_LVD;
    EXTI_InitStruct.Mode = EXTI_MODE_IT;
    EXTI_InitStruct.Trigger = EXTI_TRIGGER_RISING;
    EXTI_InitStruct.Cmd = ENABLE;
    EXTI_Init(&EXTI_InitStruct);
    
    NVIC_ClearPendingIRQ(LVD_IRQn);
    NVIC_SetPriority(LVD_IRQn, 5);
    NVIC_EnableIRQ(LVD_IRQn);
}

/******************************************************************************
* @brief : Set LVD.
* @param : None
* @return: None
******************************************************************************/
void LVD_Init(void)
{
    //LVD ֵѹѡ
    PMU_LVDVoltageConfig(PMU_LVDVOLTAGE_2V73);
    
    //LVD ˲ʱ
    PMU_LVDFilterConfig(PMU_LVDFILTER_16SAMPLE);
    
    //˲ʹ
    PMU_LVDFilterCmd(ENABLE);
    
    //LVD ʹ
    PMU_LVDCmd(ENABLE);
    
}



/******************************************************************************
* @brief : LVD test.
* @param : mode: LVD_IRQ or LVD_RESET
* @return: None
******************************************************************************/
void APP_LVD_Test(uint8_t mode)
{
    printfS("LVD Test...... \r\n");

    PMU_Init();	

    LVD_Init();
    
    if(mode == LVD_IRQ)
    {
        LVD_IRQ_Init();
        __RCC_LVDRSTTOSYSRST_DISABLE(); 
    }
    else
    {
        __RCC_LVDRSTTOSYSRST_ENABLE();
    }


    while (1) 
    {
        printfS("Systick = %d\r\n", SysTick_Get());
        DelayMs(1000);
    }
    
}

