
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 


/******************************************************************************
* @brief : Set IO Wakeup.
* @param : None
* @return: None
******************************************************************************/
void Wakeup_IO_Init(void)
{
    //Wakeup2(PC13)ߵƽ 
    PMU_WakeUpPinPolarityConfig(PMU_WAKEUP_PIN2, PMU_WAKEUPPIN_POLARITY_HIGH);
    
    //Wakeup2(PC13)ܽ˲ʹ
    PMU_WakeUpPinFilterCmd(PMU_WAKEUP_PIN2, ENABLE);
    
    //Standbyѵȴʱ
    PMU_SetSTANDBYWakeWaitTime(PMU_STANDBYWAKEWAIT_4RC32K);
    
    //Wakeup2(PC13)ܽŻѹʹ
    PMU_WakeUpPinCmd(PMU_WAKEUP_PIN2, ENABLE);
}

/******************************************************************************
* @brief : Set RTC Wakeup.
* @param : None
* @return: None
******************************************************************************/
void Wakeup_RTC_Init(void)
{
    //RTCʼ
    RTC_Init(RTC_CLOCK_XTL);
    
    //ʼʱӲ
    RTC_CoarseCalibConfig(RTC_CALIBSIGN_POSITIVE, 5);
   
    //32жϱ־
    RTC_ClearFlag(RTC_IT_FLAG_32S);    
    
    //ʹ32ж
    RTC_ITConfig(RTC_IT_FLAG_32S, ENABLE);
}

/******************************************************************************
* @brief : Enter Standby.
* @param : None
* @return: None
******************************************************************************/
void Standby_Mode(void)
{
    printfS("MCU enter standby mode \r\n");  
    SysTick->CTRL &= ~SysTick_CTRL_TICKINT_Msk;   // disable systick        
    __set_PRIMASK(1);    // disable interrupt 
    SCB->ICSR = BIT25;   // clear systick pending bit
    
    PMU_EnterSTANDBYMode(PMU_LOWPOWRENTRY_WFI);
    
    SysTick->CTRL |= SysTick_CTRL_TICKINT_Msk; /* Enable SysTick IRQ */               
    __set_PRIMASK(0);    // enable interrupt 
    while(1)
    {
        printfS("MCU never run here \r\n");
    }
}


/******************************************************************************
* @brief : Low power standby test.
* @param : mode: wakeup source select(IO or RTC) 
* @return: none
******************************************************************************/
void APP_LowPower_Standby_Mode_Test(uint8_t mode)
{
    FlagStatus result = RESET;
    
    PMU_Init();
    
    result = PMU_GetFlagStatus(PMU_FLAG_SB);
    
    if(result == SET)
    {
        printfS("MCU has entered standby mode!\n");
    }
    switch(mode)
    {
        /* standbyģʽ IO */
        case PMU_STANDBY_IO_WAKEUP:
        {
            printfS("MCU Standby wakeup by IO Test \r\n"); 
            
            result = PMU_GetFlagStatus(PMU_FLAG_WUPF2);
            if(result == SET)
            {
                printfS("WakeUp by PC13(WAKEUP2) \n");
                PMU_ClearFlag(PMU_SR_WUPFX_2);
            }
                
            DelayMs(5000);
            
            Wakeup_IO_Init();
            
            Standby_Mode();

        }
        /* standbyģʽ RTC */
        case PMU_STANDBY_RTC_WAKEUP:
        {	
            printfS("MCU Standby wakeup by RTC Test \r\n");

            PMU_WakeUpPinCmd(PMU_WAKEUP_PIN2, DISABLE);
            
            result = PMU_GetFlagStatus(PMU_FLAG_RTC);
            if(result == SET)
            {
                printfS("WakeUp by RTC \n");
                PMU_ClearFlag(PMU_FLAG_RTC);
            }
            
            DelayMs(5000); 

            Wakeup_RTC_Init();            

            Standby_Mode();
        }
        default: 
        printfS("The application is not supported\r\n");
        break; 
    }
    
}

