
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 


/******************************************************************************
* @brief : Set IO Wakeup.
* @param : None
* @return: None
******************************************************************************/
void Wakeup_IO_Init(void)
{
    GPIO_InitTypeDef GPIO_InitStruct;
    EXTI_InitTypeDef EXTI_InitStruct;
    
    __RCC_EXTI_CLK_ENABLE();
    __RCC_GPIOC_CLK_ENABLE();


	/*---------------------------EXTI_Line13-----------------------------*/  	
	/* Initialization GPIO */
    GPIO_InitStruct.Pin       = GPIO_PIN_13;
    GPIO_InitStruct.Mode      = GPIO_MODE_INPUT;
    GPIO_InitStruct.Pull      = GPIO_NOPULL;
	GPIO_InitStruct.Drive     = GPIO_DRIVE_LEVEL3;
    GPIO_Init(GPIOC, &GPIO_InitStruct);
    
    /* Config EXTI */
    EXTI_InitStruct.GPIOx = GPIOC;
    EXTI_InitStruct.Line = EXTI_LINE_13;
    EXTI_InitStruct.Mode = EXTI_MODE_IT;
    EXTI_InitStruct.Trigger = EXTI_TRIGGER_RISING;
    EXTI_InitStruct.Cmd = ENABLE;
    EXTI_Init(&EXTI_InitStruct);
    
    NVIC_ClearPendingIRQ(EXTI15_10_IRQn);
    NVIC_SetPriority(EXTI15_10_IRQn, 5);
    NVIC_EnableIRQ(EXTI15_10_IRQn);
}



/******************************************************************************
* @brief : Low power standby test.
* @param : mode: wakeup source select(IO or RTC) 
* @return: none
******************************************************************************/
void APP_LowPower_Stop_Mode_Test(uint8_t mode)
{
    printfS("LowPower Stop%d Mode Test...... \r\n", mode);
    
    PMU_Init();	
    
    Wakeup_IO_Init();

    
    if(mode == PMU_STOP_2)
    {
        NVIC_ClearPendingIRQ(STOP_RESET_IRQn);
        NVIC_SetPriority(STOP_RESET_IRQn, 5);
        NVIC_EnableIRQ(STOP_RESET_IRQn);
    }
    
    DelayMs(3000);
    

    while (1) 
    {
        printfS("MCU Enter Lowpower, Press User EXIT Pin To Wakeup MCU!\n"); 
        
        extern void Enter_Stop_Ram(uint8_t mode);
        Enter_Stop_Ram(mode);                 
             
        Delay_Simple(100);
                    
        SystemClock_Config();//л120MHZ 

        BSP_UART_Init(); 

        printfS("************\r\n"); 
        printfS("************\r\n"); 
        printfS("************\r\n");         
        printfS("Exit Stop%d\r\n", mode); 
        printfS("************\r\n"); 
        printfS("************\r\n"); 
        printfS("************\r\n");         
        DelayMs(3000);

    }
    
}

