
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 



/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t i;
    uint32_t freq;
    
	printfS("SPL RCC Demo\r\n");
	printfS("\r\n");
    
	BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    // RC64M
    RCC_RC64MConfig(RCC_RC64M_DIV1);
    RCC_RC64MCmd(ENABLE);
    if (RCC_WaitForRC64MStartUp() == ERROR)
    {
        printfS("RC64M stabilization timeout.\r\n");
        while (1);
    }
    
	printfS("RC64M frequency: %u\r\n", RCC_GetRC64MFreq());
    
    RCC_MCO1Cmd(DISABLE);
    RCC_MCO1Config(RCC_MCO_RC64M, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
    // SYSCLK: RC64M
    RCC_SYSCLKConfig(RCC_SYSCLKSOURCE_RC64M);
    RCC_HCLKConfig(RCC_SYSDIV0_DIV_2, RCC_SYSDIV1_DIV_1);
    RCC_PCLK1Config(RCC_PCLK1_DIV_2);
    RCC_PCLK2Config(RCC_PCLK2_DIV_4);
    
    SystemCoreClockUpdate();
    SysTick_Config(RCC_GetHCLKFreq() / 1000);
    
    BSP_UART_Init();  
	
	printfS("HCLK frequency: %u\r\n", RCC_GetHCLKFreq());
    
    RCC_MCO1Config(RCC_MCO_HCLK, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
	printfS("PCLK1 frequency: %u\r\n", RCC_GetPCLK1Freq());
    
    RCC_MCO1Config(RCC_MCO_PCLK1, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
	printfS("PCLK2 frequency: %u\r\n", RCC_GetPCLK2Freq());
    
    RCC_MCO1Config(RCC_MCO_PCLK2, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
    // XTH
    RCC_XTHConfig(RCC_XTH_ON);
    if (RCC_WaitForXTHStartUp() == ERROR)
    {
        printfS("XTH stabilization timeout.\r\n");
        while (1);
    }
    
	printfS("XTH frequency: %u\r\n", RCC_GetXTHFreq());
        
    RCC_MCO1Config(RCC_MCO_XTH, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
    // XTL
    RCC_XTLConfig(RCC_XTL_DRIVE3, DISABLE);
    RCC_XTLCmd(ENABLE);
    
    if (RCC_WaitForXTLStartUp() == ERROR)
    {
        printfS("XTL stabilization timeout.\r\n");
        while (1);
    }
    
	printfS("XTL frequency: %u\r\n", RCC_GetXTLFreq());
    
    RCC_MCO1Config(RCC_MCO_XTL, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
    // RC32K
    RCC_RC32KCmd(ENABLE);
    
    if (RCC_WaitForRC32KStartUp() == ERROR)
    {
        printfS("RC32K stabilization timeout.\r\n");
        while (1);
    }
    
	printfS("RC32K frequency: %u\r\n", RCC_GetRC32KFreq());
    
    RCC_MCO1Config(RCC_MCO_RC32K, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
    // PLL
    RCC_PLLCmd(ENABLE);
    RCC_PLLConfig(RCC_PLLSOURCE_XTH, 0, 2, 15);
    RCC_PLLUpdateCmd(ENABLE);
    
    if (RCC_WaitForPLLStartUp() == ERROR)
    {
        printfS("PLL stabilization timeout.\r\n");
        while (1);
    }
    
	printfS("PLL frequency: %u\r\n", RCC_GetPLLFreq());
    
    RCC_MCO1Config(RCC_MCO_PLLCLK, 10, RCC_MCO1_POL_LOW);
    RCC_MCO1Cmd(ENABLE);
    DelayMs(10000);
    
    while(1)
    {
		DelayMs(500);
    };
}

