
/******************************************************************************
*@file  : acm32g103_it.c
*@brief : Main Interrupt Service Routines
*           This file provides template for all exceptions handler and 
*           peripherals interrupt service routine.  
******************************************************************************/

#include "app.h"
#include "acm32g103_it.h"

void NMI_Handler(void)
{   
}


void HardFault_Handler(void)
{
    while (1)
    {
    }
}


void MemManage_Handler(void)
{
    while (1)
    {
    }
}


void BusFault_Handler(void)
{
    while (1)
    {
    }
}


void UsageFault_Handler(void)
{
    while (1)
    {
    }
}


void SVC_Handler(void)
{
}


void DebugMon_Handler(void)
{
}


void PendSV_Handler(void)
{
}


/******************************************************************************
*@brief : System tick handler
*@param : none
*@return: none
******************************************************************************/
void SysTick_Handler(void)
{
	SysTick_Inc();
}

extern SPI_Handler_t    hspi;
void SPI1_IRQHandler(void)
{
    /* SPI interrupt process function */
    SPI_IRQHandler(SPI1, &hspi);
}

void SPI2_IRQHandler(void)
{
    /* SPI interrupt process function */
    SPI_IRQHandler(SPI2, &hspi);
}

void SPI3_IRQHandler(void)
{
    /* SPI interrupt process function */
    SPI_IRQHandler(SPI3, &hspi);
}

void DMA1_IRQHandler(void)
{
    extern bool flag_dma_tx;
    extern bool flag_dma_rx;
    
    if(DMA_GetFlagStatus(DMA1_Channel0, DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel0, DMA_FLAG_TC);
        flag_dma_tx = true;
    }
    
    if(DMA_GetFlagStatus(DMA1_Channel1, DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel1, DMA_FLAG_TC);
        flag_dma_rx = true;
    }
}

