
/******************************************************************************
*@file  : main.c
*@brief : main program
******************************************************************************/

#include "main.h" 
#include "app.h"   

/******************************************************************************
*@brief : main program
*@param : none
*@return: none
******************************************************************************/
int main(void)
{
    RCC_ClocksTypeDef RCC_Clocks;
    
	#if (INS_ACCELERATE_ENABLE == 1)
		System_EnableIAccelerate();
	#endif

	#if (DATA_ACCELERATE_ENABLE == 1)
		System_EnableDAccelerate();
	#endif     
    
	/* Set Interrupt Group Priority */
	NVIC_SetPriorityGrouping(NVIC_PRIORITYGROUP_4);
    
    SystemClock_Config();    
    
    SystemCoreClockUpdate();
    
    RCC_GetClocksFreq(&RCC_Clocks);
    
    SysTick_Config(RCC_Clocks.HCLK_Frequency / 1000);
    
    BSP_UART_Init();
    
//    BSP_PB_Init();
	
    /**  
        TEST_MASTER_COMM,
        TEST_MASTER_IT,
        TEST_MASTER_DMA,
        TEST_MASTER_FULL_DUPLEX,
        TEST_MASTER_NOR_FLASH, 
    */
    SPI_Master_Test(TEST_MASTER_COMM);
    
    while(1)
    {
        
    }
}














