
/******************************************************************************
*@file  : acm32g103_it.c
*@brief : Main Interrupt Service Routines
*           This file provides template for all exceptions handler and 
*           peripherals interrupt service routine.  
******************************************************************************/

#include "app.h"
#include "acm32g103_it.h"


void NMI_Handler(void)
{   
}


void HardFault_Handler(void)
{
    while (1)
    {
    }
}


void MemManage_Handler(void)
{
    while (1)
    {
    }
}


void BusFault_Handler(void)
{
    while (1)
    {
    }
}


void UsageFault_Handler(void)
{
    while (1)
    {
    }
}


void SVC_Handler(void)
{
}


void DebugMon_Handler(void)
{
}


void PendSV_Handler(void)
{
}


/******************************************************************************
*@brief : System tick handler
*@param : none
*@return: none
******************************************************************************/
void SysTick_Handler(void)
{
	SysTick_Inc();
}

extern void UART_RxCpltCallback(void);
void UART1_IRQHandler(void)
{
    if(UART_GetITStatus(UART1, UART_IT_RXI) != RESET)
    {
        while(!UART_GetFlagStatus(UART1, UART_FR_RXFE))
        {
            /* Read one byte from the receive data register */
            if(rx_cnt >= BUF_SIZE)
                rx_cnt = 0;           
            RxBuffer[rx_cnt++] = (UART_ReceiveData(UART1) & 0xFF);
        }

        if(rx_cnt == read_size)
        {
            /* Disable the EVAL_COM1 Receive interrupt */
            UART_ITConfig(UART1, UART_IT_RXI, DISABLE);
            UART_RxCpltCallback();
        }
    }

    if(UART_GetITStatus(UART1, UART_IT_TXI) != RESET)
    {   
        if(tx_cnt == send_size)
        {
              /* Disable the EVAL_COM1 Transmit interrupt */
              UART_ITConfig(UART1, UART_IT_TXI, DISABLE);
        }
        else
            /* Write one byte to the transmit data register */
            UART_SendData(UART1, TxBuffer[tx_cnt++]);
    }
  
    if(UART_GetITStatus(UART1, UART_IT_IDLEI) != RESET)
    {
        UART_ClearITPendingBit(UART1, UART_ISR_IDLEI);

        while(!UART_GetFlagStatus(UART1, UART_FR_RXFE))
        {
            /* Read one byte from the receive data register */
            if(rx_cnt >= BUF_SIZE)
                rx_cnt = 0;
            RxBuffer[rx_cnt++] = (UART_ReceiveData(UART1) & 0xFF);
        }
        
        UART_RxCpltCallback();
    }

}

void DMA1_IRQHandler(void)
{
    extern volatile bool TX_DMA_Status;
    if(DMA_GetFlagStatus(DMA1_Channel0, DMA_FLAG_TC))
    {
        DMA_ClearFlag(DMA1_Channel0, DMA_FLAG_TC);
        TX_DMA_Status = true;
    }
}
