
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

volatile uint32_t g_feeddog;

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t prev_tick;
    uint32_t curr_tick;
    
	printfS("SPL WDT Demo: interrupt mode.\r\n");
	printfS("\r\n");
    
    BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    
    __RCC_WDTRSTTOSYSRST_ENABLE();
    
    WDT_DeInit();
    __RCC_WDT_CLK_ENABLE();
    
    WDT_SetPrescaler(WDT_CLOCK_PRESCALER_128);
    
    WDT_SetMode(WDT_MODE_INTERRUPT);
    
    WDT_SetLoadValue(3000 * ((RCC_GetPCLK1Freq() / 128) / 1000));   // 500ms
    WDT_SetITClrTime(5 * ((RCC_GetPCLK1Freq() / 128) / 1000));    // 50ms
    
    WDT_Cmd(ENABLE);
    
    prev_tick = SysTick_Get();
    
    printfS("WDT reset period : 3000 ms.\r\n");
    printfS("WDT feed dog period : 3000 ms.\r\n");
    printfS("If the WDT feed dog fails, the system will be reset.\r\n");
    printfS("\r\n");
    
    WDT_ITCmd(ENABLE);
    
    // Enable NVIC IRQ
    NVIC_ClearPendingIRQ(WDT_IRQn);
    NVIC_SetPriority(WDT_IRQn, 0x00);
    NVIC_EnableIRQ(WDT_IRQn);
    
    g_feeddog = 0;
    while(1)
    {
        while (g_feeddog == 0);
        g_feeddog = 0;
        curr_tick = SysTick_Get();
        printfS("WDT feed dog succeeded, The current TICK is %u ms, and the TICK interval is %u ms.\r\n", \
                                            curr_tick, curr_tick - prev_tick);
        prev_tick = curr_tick;
        BSP_LED_Toggle();
    };
}

void iwdt_irq_handle(void)
{
    WDT_FeedDog();
    g_feeddog = 1;
}
