
/******************************************************************************
*@file  : app.c
*@brief : application
******************************************************************************/

#include "app.h" 

/******************************************************************************
*@brief : app test
*@param : none
*@return: none
******************************************************************************/
void APP_Test(void)
{
    uint32_t freq;
    uint32_t curr_tick;
    uint32_t end_tick;
    uint32_t period;
    
	printfS("SPL WDT Demo: reset mode.\r\n");
	printfS("\r\n");
    
    BSP_LED_Init();
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    BSP_LED_On();
    DelayMs(500);
    BSP_LED_Off();
    DelayMs(500);
    
    
    __RCC_WDTRSTTOSYSRST_ENABLE();
    
    WDT_DeInit();
    __RCC_WDT_CLK_ENABLE();
    
    WDT_SetPrescaler(WDT_CLOCK_PRESCALER_128);
    
    WDT_SetMode(WDT_MODE_RESET);
    
    WDT_SetLoadValue((RCC_GetPCLK1Freq() / 128) * 3);
    
    WDT_Cmd(ENABLE);
    
    curr_tick = SysTick_Get();
    end_tick = curr_tick + 3000 - 20; 
    
    printfS("WDT reset period : 3000 ms.\r\n");
    printfS("WDT feed dog period : 2980 ms.\r\n");
    printfS("If the WDT feed dog fails, the system will be reset.\r\n");
    printfS("\r\n");
    
    while(1)
    {
        curr_tick = SysTick_Get();
        if (curr_tick >= end_tick)
        {
            WDT_FeedDog();
            
            BSP_LED_Toggle();
            
            printfS("WDT feed dog succeeded, The current TICK is %u ms, and the TICK interval is %u ms.\r\n", \
                          curr_tick, curr_tick - (end_tick - (3000 - 20)));
            
            end_tick += 3000 - 20;
            
        }
    };
}


