
/******************************************************************************
*@file  : acm32g103_coreboard.h
*@brief : This file provides set of firmware functions to manage Leds and 
*         push-button available on ACM32G103 Core Board 
******************************************************************************/

#ifndef __ACM32G103_COREBOARD_H
#define __ACM32G103_COREBOARD_H
                                            
#include "acm32g103_spl_conf.h"

#define BSP_LED_GPIO            GPIOF
#define BSP_LED_PIN             GPIO_PIN_3
#define BSP_LED_MODE            GPIO_MODE_OUTPUT_PP
#define BSP_LED_PULL            GPIO_PULLUP
#define BSP_LED_DRIVE           GPIO_DRIVE_LEVEL3
#define BSP_LED_ALTERNATE       GPIO_FUNCTION_0
#define BSP_LED_CLK_ENABLE()    __RCC_GPIOF_CLK_ENABLE()

#define BSP_PB_GPIO             GPIOC
#define BSP_PB_PIN              GPIO_PIN_13
#define BSP_PB_MODE             GPIO_MODE_INPUT
#define BSP_PB_PULL             GPIO_PULLUP
#define BSP_PB_DRIVE            GPIO_DRIVE_LEVEL3
#define BSP_PB_ALTERNATE        GPIO_FUNCTION_0
#define BSP_PB_IRQ              EXTI15_10_IRQn
#define BSP_PB_CLK_ENABLE()    __RCC_GPIOC_CLK_ENABLE()

#define BSP_MCO1_GPIO            GPIOA
#define BSP_MCO1_PIN             GPIO_PIN_8
#define BSP_MCO1_MODE            GPIO_MODE_AF_PP
#define BSP_MCO1_PULL            GPIO_NOPULL
#define BSP_MCO1_DRIVE           GPIO_DRIVE_LEVEL3
#define BSP_MCO1_ALTERNATE       GPIO_FUNCTION_0
#define BSP_MCO1_CLK_ENABLE()    __RCC_GPIOA_CLK_ENABLE()

#define BSP_MCO2_GPIO           GPIOB
#define BSP_MCO2_PIN            GPIO_PIN_1
#define BSP_MCO2_MODE           GPIO_MODE_OUTPUT_PP
#define BSP_MCO2_PULL           GPIO_PULLUP
#define BSP_MCO2_DRIVE          GPIO_DRIVE_LEVEL3
#define BSP_MCO2_ALTERNATE      GPIO_FUNCTION_3
#define BSP_MCO2_CLK_ENABLE()   __RCC_GPIOB_CLK_ENABLE()

    


void get_reset_source(void);
void BSP_MCO_Init(void);
void BSP_LED_Init(void);
void BSP_LED_On(void);
void BSP_LED_Off(void);
void BSP_LED_Toggle(void);
void BSP_PB_Init(void);
uint32_t BSP_PB_GetState(void);
void BSP_UART_Init(void);
void BSP_UART_DeInit(void);

#endif /* __ACM32G103_CORE_H */

