#ifndef __BSP_I2C_H
#define __BSP_I2C_H

#include "spl_i2c.h"

/** @defgroup I2C State machine
 *  @{
 */
#define    I2C_STATE_IDLE       (0U)
#define    I2C_STATE_TX_DATA    (1U)
#define    I2C_STATE_RX_DATA    (2U)    
#define    I2C_STATE_REQ_ADDR   (3U)
#define    I2C_STATE_RX_ADDR    (4U)
/**
  * @}
  */ 

typedef enum
{
    
	I2C_OK       = 0x00U,   
	I2C_ERROR    = 0x01U,    
	I2C_BUSY     = 0x02U,    
	I2C_TIMEOUT  = 0x03U
	
}I2C_StatusTypeDef;

/**
  * @brief  I2C Slave Communication Structure definition
  */
typedef struct
{
    uint32_t                    state;
      
    __IO uint32_t               Rx_Size;          /* I2C Rx Size */
    __IO uint32_t               Tx_Size;          /* I2C Tx Size */
    
    __IO uint32_t               Rx_Count;         /* I2C Rx Count */
    __IO uint32_t               Tx_Count;         /* I2C Tx Count */
	
	__IO uint8_t               *Rx_Buffer;        /* I2C Rx Buffer */
    __IO uint8_t               *Tx_Buffer;        /* I2C Tx Buffer */

    DMA_Channel_TypeDef        *DMA_Rx_ch;
    DMA_Channel_TypeDef        *DMA_Tx_ch;
    
    __IO void (*I2C_STOPF_Callback)(void);      /* I2C STOP flag interrupt callback */

}I2C_Handler_t;

void I2C_IRQHandler(I2C_TypeDef* I2Cx, I2C_Handler_t* hi2c);


uint8_t I2C_Mem_Write(I2C_TypeDef* I2Cx,uint8_t DevAddress, uint16_t MemAddress, uint16_t MemAddSize, uint8_t *pData, uint32_t Size, uint32_t Timeout);

uint8_t I2C_Mem_Read(I2C_TypeDef* I2Cx, uint8_t DevAddress, uint16_t MemAddress, uint16_t MemAddSize, uint8_t *pData, uint16_t Size, uint32_t Timeout);

uint8_t I2C_Master_Transmit(I2C_TypeDef* I2Cx, uint16_t DevAddress, uint8_t *pData, uint32_t Size, uint32_t Timeout);

uint8_t I2C_Master_Receive(I2C_TypeDef* I2Cx, uint16_t DevAddress, uint8_t *pData, uint16_t Size, uint32_t Timeout);

uint8_t I2C_Slave_Transmit(I2C_TypeDef* I2Cx, uint8_t *pData, uint32_t Size, uint32_t Timeout);

uint8_t I2C_Slave_Receive(I2C_TypeDef* I2Cx, uint8_t *pData, uint32_t Size, uint32_t Timeout);

uint8_t I2C_Master_Transmit_IT(I2C_TypeDef* I2Cx, uint16_t DevAddress, I2C_Handler_t* hi2c, uint8_t *pData, uint16_t Size);
uint8_t I2C_Master_Receive_IT(I2C_TypeDef* I2Cx, uint16_t DevAddress, I2C_Handler_t* hi2c, uint8_t *pData, uint16_t Size);

uint8_t I2C_Slave_Transmit_IT(I2C_TypeDef* I2Cx, I2C_Handler_t* hi2c, uint8_t *pData, uint32_t Size);

uint8_t I2C_Slave_Receive_IT(I2C_TypeDef* I2Cx, I2C_Handler_t* hi2c, uint8_t *pData, uint32_t Size);

#endif  /* __BSP_SPI_H */
